
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("PoissonDistribution")
@JsonPropertyOrder({
    "mean",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class PoissonDistribution
    extends ContinuousDistribution
    implements HasExtensions<PoissonDistribution>
{

    @XmlAttribute(name = "mean", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public PoissonDistribution() {
    }

    @ValueConstructor
    public PoissonDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
    }

    public Number requireMean() {
        if (this.mean == null) {
            throw new MissingAttributeException(this, PMMLAttributes.POISSONDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Number getMean() {
        return mean;
    }

    public PoissonDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public PoissonDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
