
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("TextModelNormalization")
@JsonPropertyOrder({
    "localTermWeights",
    "globalTermWeights",
    "documentNormalization",
    "extensions"
})
public class TextModelNormalization
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextModelNormalization>
{

    @XmlAttribute(name = "localTermWeights")
    @JsonProperty("localTermWeights")
    private TextModelNormalization.LocalTermWeights localTermWeights;
    @XmlAttribute(name = "globalTermWeights")
    @JsonProperty("globalTermWeights")
    private TextModelNormalization.GlobalTermWeights globalTermWeights;
    @XmlAttribute(name = "documentNormalization")
    @JsonProperty("documentNormalization")
    private TextModelNormalization.DocumentNormalization documentNormalization;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public TextModelNormalization.LocalTermWeights getLocalTermWeights() {
        if (localTermWeights == null) {
            return TextModelNormalization.LocalTermWeights.TERM_FREQUENCY;
        } else {
            return localTermWeights;
        }
    }

    public TextModelNormalization setLocalTermWeights(
        @Property("localTermWeights")
        TextModelNormalization.LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public TextModelNormalization.GlobalTermWeights getGlobalTermWeights() {
        if (globalTermWeights == null) {
            return TextModelNormalization.GlobalTermWeights.INVERSE_DOCUMENT_FREQUENCY;
        } else {
            return globalTermWeights;
        }
    }

    public TextModelNormalization setGlobalTermWeights(
        @Property("globalTermWeights")
        TextModelNormalization.GlobalTermWeights globalTermWeights) {
        this.globalTermWeights = globalTermWeights;
        return this;
    }

    public TextModelNormalization.DocumentNormalization getDocumentNormalization() {
        if (documentNormalization == null) {
            return TextModelNormalization.DocumentNormalization.NONE;
        } else {
            return documentNormalization;
        }
    }

    public TextModelNormalization setDocumentNormalization(
        @Property("documentNormalization")
        TextModelNormalization.DocumentNormalization documentNormalization) {
        this.documentNormalization = documentNormalization;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public TextModelNormalization addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum DocumentNormalization
        implements StringValue<TextModelNormalization.DocumentNormalization>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("cosine")
        @JsonProperty("cosine")
        COSINE("cosine");
        private final String value;

        DocumentNormalization(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TextModelNormalization.DocumentNormalization fromValue(String v) {
            for (TextModelNormalization.DocumentNormalization c: TextModelNormalization.DocumentNormalization.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum GlobalTermWeights
        implements StringValue<TextModelNormalization.GlobalTermWeights>
    {

        @XmlEnumValue("inverseDocumentFrequency")
        @JsonProperty("inverseDocumentFrequency")
        INVERSE_DOCUMENT_FREQUENCY("inverseDocumentFrequency"),
        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @JsonProperty("GFIDF")
        GFIDF("GFIDF"),
        @XmlEnumValue("normal")
        @JsonProperty("normal")
        NORMAL("normal"),
        @XmlEnumValue("probabilisticInverse")
        @JsonProperty("probabilisticInverse")
        PROBABILISTIC_INVERSE("probabilisticInverse");
        private final String value;

        GlobalTermWeights(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TextModelNormalization.GlobalTermWeights fromValue(String v) {
            for (TextModelNormalization.GlobalTermWeights c: TextModelNormalization.GlobalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LocalTermWeights
        implements StringValue<TextModelNormalization.LocalTermWeights>
    {

        @XmlEnumValue("termFrequency")
        @JsonProperty("termFrequency")
        TERM_FREQUENCY("termFrequency"),
        @XmlEnumValue("binary")
        @JsonProperty("binary")
        BINARY("binary"),
        @XmlEnumValue("logarithmic")
        @JsonProperty("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("augmentedNormalizedTermFrequency")
        @JsonProperty("augmentedNormalizedTermFrequency")
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");
        private final String value;

        LocalTermWeights(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TextModelNormalization.LocalTermWeights fromValue(String v) {
            for (TextModelNormalization.LocalTermWeights c: TextModelNormalization.LocalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
