
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MaximumLikelihoodStat", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "kalmanState",
    "thetaRecursionState"
})
@JsonRootName("MaximumLikelihoodStat")
@JsonPropertyOrder({
    "method",
    "periodDeficit",
    "kalmanState",
    "thetaRecursionState"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class MaximumLikelihoodStat
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "method", required = true)
    @JsonProperty("method")
    private MaximumLikelihoodStat.Method method;
    @XmlAttribute(name = "periodDeficit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("periodDeficit")
    private Integer periodDeficit;
    @XmlElement(name = "KalmanState", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("KalmanState")
    private KalmanState kalmanState;
    @XmlElement(name = "ThetaRecursionState", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ThetaRecursionState")
    private ThetaRecursionState thetaRecursionState;
    private static final Integer DEFAULT_PERIOD_DEFICIT = new IntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371272L;

    public MaximumLikelihoodStat() {
    }

    @ValueConstructor
    public MaximumLikelihoodStat(
        @org.jpmml.model.annotations.Property("method")
        MaximumLikelihoodStat.Method method,
        @org.jpmml.model.annotations.Property("kalmanState")
        KalmanState kalmanState,
        @org.jpmml.model.annotations.Property("thetaRecursionState")
        ThetaRecursionState thetaRecursionState) {
        this.method = method;
        this.kalmanState = kalmanState;
        this.thetaRecursionState = thetaRecursionState;
    }

    public MaximumLikelihoodStat.Method requireMethod() {
        if (this.method == null) {
            throw new MissingAttributeException(this, PMMLAttributes.MAXIMUMLIKELIHOODSTAT_METHOD);
        }
        return this.method;
    }

    public MaximumLikelihoodStat.Method getMethod() {
        return method;
    }

    public MaximumLikelihoodStat setMethod(
        @org.jpmml.model.annotations.Property("method")
        MaximumLikelihoodStat.Method method) {
        this.method = method;
        return this;
    }

    public Integer getPeriodDeficit() {
        if (periodDeficit == null) {
            return DEFAULT_PERIOD_DEFICIT;
        } else {
            return periodDeficit;
        }
    }

    public MaximumLikelihoodStat setPeriodDeficit(
        @org.jpmml.model.annotations.Property("periodDeficit")
        Integer periodDeficit) {
        this.periodDeficit = periodDeficit;
        return this;
    }

    public KalmanState requireKalmanState() {
        if (this.kalmanState == null) {
            throw new MissingElementException(this, PMMLElements.MAXIMUMLIKELIHOODSTAT_KALMANSTATE);
        }
        return this.kalmanState;
    }

    public KalmanState getKalmanState() {
        return kalmanState;
    }

    public MaximumLikelihoodStat setKalmanState(
        @org.jpmml.model.annotations.Property("kalmanState")
        KalmanState kalmanState) {
        this.kalmanState = kalmanState;
        return this;
    }

    public ThetaRecursionState requireThetaRecursionState() {
        if (this.thetaRecursionState == null) {
            throw new MissingElementException(this, PMMLElements.MAXIMUMLIKELIHOODSTAT_THETARECURSIONSTATE);
        }
        return this.thetaRecursionState;
    }

    public ThetaRecursionState getThetaRecursionState() {
        return thetaRecursionState;
    }

    public MaximumLikelihoodStat setThetaRecursionState(
        @org.jpmml.model.annotations.Property("thetaRecursionState")
        ThetaRecursionState thetaRecursionState) {
        this.thetaRecursionState = thetaRecursionState;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getKalmanState(), getThetaRecursionState());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Method
        implements StringValue<MaximumLikelihoodStat.Method>
    {

        @XmlEnumValue("kalman")
        @JsonProperty("kalman")
        KALMAN("kalman"),
        @XmlEnumValue("thetaRecursion")
        @JsonProperty("thetaRecursion")
        THETA_RECURSION("thetaRecursion");
        private final String value;

        Method(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static MaximumLikelihoodStat.Method fromValue(String v) {
            for (MaximumLikelihoodStat.Method c: MaximumLikelihoodStat.Method.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
