/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.time_series.Denominator;
import org.dmg.pmml.time_series.Numerator;
import org.dmg.pmml.time_series.PMMLAttributes;
import org.dmg.pmml.time_series.RegressorValues;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="DynamicRegressor", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "numerator", "denominator", "regressorValues"})
@JsonRootName(value="DynamicRegressor")
@JsonPropertyOrder(value={"field", "transformation", "delay", "futureValuesMethod", "targetField", "extensions", "numerator", "denominator", "regressorValues"})
@Added(value=Version.PMML_4_4)
public class DynamicRegressor
extends PMMLObject
implements HasExtensions<DynamicRegressor>,
HasFieldReference<DynamicRegressor>,
HasTargetFieldReference<DynamicRegressor> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="transformation")
    @JsonProperty(value="transformation")
    private Transformation transformation;
    @XmlAttribute(name="delay")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="delay")
    private Integer delay;
    @XmlAttribute(name="futureValuesMethod")
    @JsonProperty(value="futureValuesMethod")
    private FutureValuesMethod futureValuesMethod;
    @XmlAttribute(name="targetField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="targetField")
    private String targetField;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="Numerator", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Numerator")
    private Numerator numerator;
    @XmlElement(name="Denominator", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Denominator")
    private Denominator denominator;
    @XmlElement(name="RegressorValues", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="RegressorValues")
    private RegressorValues regressorValues;
    private static final Integer DEFAULT_DELAY = new IntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371272L;

    public DynamicRegressor() {
    }

    @ValueConstructor
    public DynamicRegressor(@Property(value="field") String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public DynamicRegressor(Field<?> field) {
        this(field != null ? field.requireName() : null);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DYNAMICREGRESSOR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public DynamicRegressor setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return Transformation.NONE;
        }
        return this.transformation;
    }

    public DynamicRegressor setTransformation(@Property(value="transformation") Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Integer getDelay() {
        if (this.delay == null) {
            return DEFAULT_DELAY;
        }
        return this.delay;
    }

    public DynamicRegressor setDelay(@Property(value="delay") Integer delay) {
        this.delay = delay;
        return this;
    }

    public FutureValuesMethod getFutureValuesMethod() {
        if (this.futureValuesMethod == null) {
            return FutureValuesMethod.CONSTANT;
        }
        return this.futureValuesMethod;
    }

    public DynamicRegressor setFutureValuesMethod(@Property(value="futureValuesMethod") FutureValuesMethod futureValuesMethod) {
        this.futureValuesMethod = futureValuesMethod;
        return this;
    }

    @Override
    public String getTargetField() {
        return this.targetField;
    }

    @Override
    public DynamicRegressor setTargetField(@Property(value="targetField") String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DynamicRegressor addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Numerator getNumerator() {
        return this.numerator;
    }

    public DynamicRegressor setNumerator(@Property(value="numerator") Numerator numerator) {
        this.numerator = numerator;
        return this;
    }

    public Denominator getDenominator() {
        return this.denominator;
    }

    public DynamicRegressor setDenominator(@Property(value="denominator") Denominator denominator) {
        this.denominator = denominator;
        return this;
    }

    public RegressorValues getRegressorValues() {
        return this.regressorValues;
    }

    public DynamicRegressor setRegressorValues(@Property(value="regressorValues") RegressorValues regressorValues) {
        this.regressorValues = regressorValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getNumerator(), this.getDenominator(), this.getRegressorValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Transformation implements StringValue<Transformation>
    {
        NONE("none"),
        LOGARITHMIC("logarithmic"),
        SQUAREROOT("squareroot");

        private final String value;

        private Transformation(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Transformation fromValue(String v) {
            for (Transformation c : Transformation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum FutureValuesMethod implements StringValue<FutureValuesMethod>
    {
        CONSTANT("constant"),
        TREND("trend"),
        STORED("stored"),
        OTHER_MODEL("otherModel"),
        USER_SUPPLIED("userSupplied");

        private final String value;

        private FutureValuesMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static FutureValuesMethod fromValue(String v) {
            for (FutureValuesMethod c : FutureValuesMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

