
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "KNNInput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("KNNInput")
@JsonPropertyOrder({
    "field",
    "fieldWeight",
    "compareFunction",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class KNNInput
    extends ComparisonField<KNNInput>
    implements HasExtensions<KNNInput>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "fieldWeight")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("fieldWeight")
    private Number fieldWeight;
    @XmlAttribute(name = "compareFunction")
    @JsonProperty("compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final Number DEFAULT_FIELD_WEIGHT = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371273L;

    public KNNInput() {
    }

    @ValueConstructor
    public KNNInput(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public KNNInput(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.KNNINPUT_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public KNNInput setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public Number getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    @Override
    public KNNInput setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Number fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    @Override
    public KNNInput setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public KNNInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
