
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "knnInputs"
})
@JsonRootName("KNNInputs")
@JsonPropertyOrder({
    "extensions",
    "knnInputs"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class KNNInputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<KNNInput> , HasExtensions<KNNInputs>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "KNNInput", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("KNNInput")
    @CollectionElementType(KNNInput.class)
    private List<KNNInput> knnInputs;
    private static final long serialVersionUID = 67371273L;

    public KNNInputs() {
    }

    @ValueConstructor
    public KNNInputs(
        @Property("knnInputs")
        List<KNNInput> knnInputs) {
        this.knnInputs = knnInputs;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public KNNInputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<KNNInput> iterator() {
        return requireKNNInputs().iterator();
    }

    public boolean hasKNNInputs() {
        return ((this.knnInputs!= null)&&(!this.knnInputs.isEmpty()));
    }

    public List<KNNInput> requireKNNInputs() {
        if ((this.knnInputs == null)||this.knnInputs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.KNNINPUTS_KNNINPUTS);
        }
        return this.knnInputs;
    }

    public List<KNNInput> getKNNInputs() {
        if (knnInputs == null) {
            knnInputs = new ArrayList<>();
        }
        return this.knnInputs;
    }

    public KNNInputs addKNNInputs(KNNInput... knnInputs) {
        getKNNInputs().addAll(Arrays.asList(knnInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasKNNInputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getKNNInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
