
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("SigmoidKernelType")
@JsonPropertyOrder({
    "description",
    "gamma",
    "coef0",
    "extensions"
})
public class SigmoidKernel
    extends Kernel
    implements HasExtensions<SigmoidKernel>
{

    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlAttribute(name = "coef0")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coef0")
    private Number coef0;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private static final Number DEFAULT_COEF0 = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371273L;

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public SigmoidKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public SigmoidKernel setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getCoef0() {
        if (coef0 == null) {
            return DEFAULT_COEF0;
        } else {
            return coef0;
        }
    }

    public SigmoidKernel setCoef0(
        @Property("coef0")
        Number coef0) {
        this.coef0 = coef0;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public SigmoidKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
