
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.CollectionElementType;

@XmlRootElement(name = "TextCorpus", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "textDocuments"
})
@JsonRootName("TextCorpus")
@JsonPropertyOrder({
    "extensions",
    "textDocuments"
})
public class TextCorpus
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextCorpus>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "TextDocument", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TextDocument")
    @CollectionElementType(TextDocument.class)
    private List<TextDocument> textDocuments;
    private static final long serialVersionUID = 67371273L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public TextCorpus addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextDocuments() {
        return ((this.textDocuments!= null)&&(!this.textDocuments.isEmpty()));
    }

    public List<TextDocument> getTextDocuments() {
        if (textDocuments == null) {
            textDocuments = new ArrayList<>();
        }
        return this.textDocuments;
    }

    public TextCorpus addTextDocuments(TextDocument... textDocuments) {
        getTextDocuments().addAll(Arrays.asList(textDocuments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTextDocuments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTextDocuments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
