
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SeasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "ar",
    "ma"
})
@JsonRootName("SeasonalComponent")
@JsonPropertyOrder({
    "p",
    "d",
    "q",
    "period",
    "extensions",
    "ar",
    "ma"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class SeasonalComponent
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SeasonalComponent> , HasARIMA<SeasonalComponent>
{

    @XmlAttribute(name = "P")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("P")
    private Integer p;
    @XmlAttribute(name = "D")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("D")
    private Integer d;
    @XmlAttribute(name = "Q")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("Q")
    private Integer q;
    @XmlAttribute(name = "period", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("period")
    private Integer period;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "AR", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("AR")
    private AR ar;
    @XmlElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MA")
    private MA ma;
    private static final Integer DEFAULT_P = new NonNegativeIntegerAdapter().unmarshal("0");
    private static final Integer DEFAULT_D = new NonNegativeIntegerAdapter().unmarshal("0");
    private static final Integer DEFAULT_Q = new NonNegativeIntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371273L;

    public SeasonalComponent() {
    }

    @ValueConstructor
    public SeasonalComponent(
        @org.jpmml.model.annotations.Property("period")
        Integer period) {
        this.period = period;
    }

    @Override
    public Integer getP() {
        if (p == null) {
            return DEFAULT_P;
        } else {
            return p;
        }
    }

    @Override
    public SeasonalComponent setP(
        @org.jpmml.model.annotations.Property("p")
        Integer p) {
        this.p = p;
        return this;
    }

    @Override
    public Integer getD() {
        if (d == null) {
            return DEFAULT_D;
        } else {
            return d;
        }
    }

    @Override
    public SeasonalComponent setD(
        @org.jpmml.model.annotations.Property("d")
        Integer d) {
        this.d = d;
        return this;
    }

    @Override
    public Integer getQ() {
        if (q == null) {
            return DEFAULT_Q;
        } else {
            return q;
        }
    }

    @Override
    public SeasonalComponent setQ(
        @org.jpmml.model.annotations.Property("q")
        Integer q) {
        this.q = q;
        return this;
    }

    public Integer requirePeriod() {
        if (this.period == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEASONALCOMPONENT_PERIOD);
        }
        return this.period;
    }

    public Integer getPeriod() {
        return period;
    }

    public SeasonalComponent setPeriod(
        @org.jpmml.model.annotations.Property("period")
        Integer period) {
        this.period = period;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public SeasonalComponent addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public AR getAR() {
        return ar;
    }

    @Override
    public SeasonalComponent setAR(
        @org.jpmml.model.annotations.Property("ar")
        AR ar) {
        this.ar = ar;
        return this;
    }

    @Override
    public MA getMA() {
        return ma;
    }

    @Override
    public SeasonalComponent setMA(
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAR(), getMA());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
