/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="DataDictionary", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "dataFields", "taxonomies"})
@JsonRootName(value="DataDictionary")
@JsonPropertyOrder(value={"numberOfFields", "extensions", "dataFields", "taxonomies"})
public class DataDictionary
extends PMMLObject
implements HasExtensions<DataDictionary> {
    @XmlAttribute(name="numberOfFields")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfFields")
    @CollectionSize(value="dataFields")
    private Integer numberOfFields;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="DataField", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="DataField")
    @Optional(value=Version.XPMML)
    @CollectionElementType(value=DataField.class)
    private List<DataField> dataFields;
    @XmlElement(name="Taxonomy", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Taxonomy")
    @CollectionElementType(value=Taxonomy.class)
    private List<Taxonomy> taxonomies;
    private static final long serialVersionUID = 67371273L;

    public Integer getNumberOfFields() {
        return this.numberOfFields;
    }

    public DataDictionary setNumberOfFields(@Property(value="numberOfFields") Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DataDictionary addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDataFields() {
        return this.dataFields != null && !this.dataFields.isEmpty();
    }

    public List<DataField> getDataFields() {
        if (this.dataFields == null) {
            this.dataFields = new ArrayList<DataField>();
        }
        return this.dataFields;
    }

    public DataDictionary addDataFields(DataField ... dataFields) {
        this.getDataFields().addAll(Arrays.asList(dataFields));
        return this;
    }

    public boolean hasTaxonomies() {
        return this.taxonomies != null && !this.taxonomies.isEmpty();
    }

    public List<Taxonomy> getTaxonomies() {
        if (this.taxonomies == null) {
            this.taxonomies = new ArrayList<Taxonomy>();
        }
        return this.taxonomies;
    }

    public DataDictionary addTaxonomies(Taxonomy ... taxonomies) {
        this.getTaxonomies().addAll(Arrays.asList(taxonomies));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasDataFields()) {
                status = PMMLObject.traverse(visitor, this.getDataFields());
            }
            if (status == VisitorAction.CONTINUE && this.hasTaxonomies()) {
                status = PMMLObject.traverse(visitor, this.getTaxonomies());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

