/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.naive_bayes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.naive_bayes.PMMLElements;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="TargetValueStats", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "targetValueStats"})
@JsonRootName(value="TargetValueStats")
@JsonPropertyOrder(value={"extensions", "targetValueStats"})
@Added(value=Version.PMML_4_2)
public class TargetValueStats
extends PMMLObject
implements Iterable<TargetValueStat>,
HasExtensions<TargetValueStats> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="TargetValueStat", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="TargetValueStat")
    @CollectionElementType(value=TargetValueStat.class)
    private List<TargetValueStat> targetValueStats;
    private static final long serialVersionUID = 67371273L;

    public TargetValueStats() {
    }

    @ValueConstructor
    public TargetValueStats(@Property(value="targetValueStats") List<TargetValueStat> targetValueStats) {
        this.targetValueStats = targetValueStats;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TargetValueStats addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<TargetValueStat> iterator() {
        return this.requireTargetValueStats().iterator();
    }

    public boolean hasTargetValueStats() {
        return this.targetValueStats != null && !this.targetValueStats.isEmpty();
    }

    public List<TargetValueStat> requireTargetValueStats() {
        if (this.targetValueStats == null || this.targetValueStats.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.TARGETVALUESTATS_TARGETVALUESTATS);
        }
        return this.targetValueStats;
    }

    public List<TargetValueStat> getTargetValueStats() {
        if (this.targetValueStats == null) {
            this.targetValueStats = new ArrayList<TargetValueStat>();
        }
        return this.targetValueStats;
    }

    public TargetValueStats addTargetValueStats(TargetValueStat ... targetValueStats) {
        this.getTargetValueStats().addAll(Arrays.asList(targetValueStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTargetValueStats()) {
                status = PMMLObject.traverse(visitor, this.getTargetValueStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

