
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("AnyDistribution")
@JsonPropertyOrder({
    "mean",
    "variance",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class AnyDistribution
    extends ContinuousDistribution
    implements HasExtensions<AnyDistribution>
{

    @XmlAttribute(name = "mean", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "variance", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("variance")
    private Number variance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371273L;

    public AnyDistribution() {
    }

    @ValueConstructor
    public AnyDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Number mean,
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public Number requireMean() {
        if (this.mean == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANYDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Number getMean() {
        return mean;
    }

    public AnyDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number requireVariance() {
        if (this.variance == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANYDISTRIBUTION_VARIANCE);
        }
        return this.variance;
    }

    public Number getVariance() {
        return variance;
    }

    public AnyDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public AnyDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
