
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "INT-SparseArray", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "indices",
    "entries"
})
@JsonRootName("INT-SparseArray")
@JsonPropertyOrder({
    "n",
    "defaultValue",
    "indices",
    "entries"
})
public class IntSparseArray
    extends SparseArray<Integer>
{

    @XmlAttribute(name = "n")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("n")
    private Integer n;
    @XmlAttribute(name = "defaultValue")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("defaultValue")
    private Integer defaultValue;
    @XmlList
    @XmlElement(name = "Indices", namespace = "http://www.dmg.org/PMML-4_4", type = Integer.class)
    @JsonProperty("Indices")
    @CollectionElementType(Integer.class)
    private List<Integer> indices;
    @XmlList
    @XmlElement(name = "INT-Entries", namespace = "http://www.dmg.org/PMML-4_4", type = Integer.class)
    @JsonProperty("INT-Entries")
    @CollectionElementType(Integer.class)
    private List<Integer> entries;
    private static final Integer DEFAULT_DEFAULT_VALUE = new IntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371273L;

    @Override
    public Integer getN() {
        return n;
    }

    @Override
    public IntSparseArray setN(
        @Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public Integer getDefaultValue() {
        if (defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        } else {
            return defaultValue;
        }
    }

    @Override
    public IntSparseArray setDefaultValue(
        @Property("defaultValue")
        Integer defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean hasIndices() {
        return ((this.indices!= null)&&(!this.indices.isEmpty()));
    }

    @Override
    public List<Integer> getIndices() {
        if (indices == null) {
            indices = new ArrayList<>();
        }
        return this.indices;
    }

    @Override
    public IntSparseArray addIndices(Integer... indices) {
        getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    @Override
    public boolean hasEntries() {
        return ((this.entries!= null)&&(!this.entries.isEmpty()));
    }

    @Override
    public List<Integer> getEntries() {
        if (entries == null) {
            entries = new ArrayList<>();
        }
        return this.entries;
    }

    @Override
    public IntSparseArray addEntries(Integer... entries) {
        getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
