
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ROCGraph", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues"
})
@JsonRootName("ROCGraph")
@JsonPropertyOrder({
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class ROCGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ROCGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "XCoordinates", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("XCoordinates")
    private XCoordinates xCoordinates;
    @XmlElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("YCoordinates")
    private YCoordinates yCoordinates;
    @XmlElement(name = "BoundaryValues", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BoundaryValues")
    private BoundaryValues boundaryValues;
    private static final long serialVersionUID = 67371273L;

    public ROCGraph() {
    }

    @ValueConstructor
    public ROCGraph(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates,
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.xCoordinates = xCoordinates;
        this.yCoordinates = yCoordinates;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public ROCGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public XCoordinates requireXCoordinates() {
        if (this.xCoordinates == null) {
            throw new MissingElementException(this, PMMLElements.ROCGRAPH_XCOORDINATES);
        }
        return this.xCoordinates;
    }

    public XCoordinates getXCoordinates() {
        return xCoordinates;
    }

    public ROCGraph setXCoordinates(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates) {
        this.xCoordinates = xCoordinates;
        return this;
    }

    public YCoordinates requireYCoordinates() {
        if (this.yCoordinates == null) {
            throw new MissingElementException(this, PMMLElements.ROCGRAPH_YCOORDINATES);
        }
        return this.yCoordinates;
    }

    public YCoordinates getYCoordinates() {
        return yCoordinates;
    }

    public ROCGraph setYCoordinates(
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.yCoordinates = yCoordinates;
        return this;
    }

    public BoundaryValues getBoundaryValues() {
        return boundaryValues;
    }

    public ROCGraph setBoundaryValues(
        @org.jpmml.model.annotations.Property("boundaryValues")
        BoundaryValues boundaryValues) {
        this.boundaryValues = boundaryValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getXCoordinates(), getYCoordinates(), getBoundaryValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
