
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasName;
import org.dmg.pmml.HasRequiredArray;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "kohonenMap",
    "array",
    "partition",
    "covariances"
})
@JsonRootName("Cluster")
@JsonPropertyOrder({
    "id",
    "name",
    "size",
    "extensions",
    "kohonenMap",
    "array",
    "partition",
    "covariances"
})
public class Cluster
    extends Entity<String>
    implements HasExtensions<Cluster> , HasName<Cluster> , HasRequiredArray<Cluster>
{

    @XmlAttribute(name = "id")
    @JsonProperty("id")
    @Added((org.dmg.pmml.Version.PMML_4_1))
    private String id;
    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "size")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("size")
    private Integer size;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("KohonenMap")
    private KohonenMap kohonenMap;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Partition")
    private Partition partition;
    @XmlElement(name = "Covariances", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Covariances")
    private Covariances covariances;
    private static final long serialVersionUID = 67371273L;

    public Cluster() {
    }

    @ValueConstructor
    public Cluster(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Cluster setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Cluster setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Integer getSize() {
        return size;
    }

    public Cluster setSize(
        @org.jpmml.model.annotations.Property("size")
        Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Cluster addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public KohonenMap getKohonenMap() {
        return kohonenMap;
    }

    public Cluster setKohonenMap(
        @org.jpmml.model.annotations.Property("kohonenMap")
        KohonenMap kohonenMap) {
        this.kohonenMap = kohonenMap;
        return this;
    }

    @Override
    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.CLUSTER_ARRAY);
        }
        return this.array;
    }

    @Override
    public Array getArray() {
        return array;
    }

    @Override
    public Cluster setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public Cluster setPartition(
        @org.jpmml.model.annotations.Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    public Covariances getCovariances() {
        return covariances;
    }

    public Cluster setCovariances(
        @org.jpmml.model.annotations.Property("covariances")
        Covariances covariances) {
        this.covariances = covariances;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getKohonenMap(), getArray(), getPartition(), getCovariances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
