
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("BaselineCell")
@JsonPropertyOrder({
    "time",
    "cumHazard",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class BaselineCell
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaselineCell>
{

    @XmlAttribute(name = "time", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("time")
    private Number time;
    @XmlAttribute(name = "cumHazard", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("cumHazard")
    private Number cumHazard;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371273L;

    public BaselineCell() {
    }

    @ValueConstructor
    public BaselineCell(
        @org.jpmml.model.annotations.Property("time")
        Number time,
        @org.jpmml.model.annotations.Property("cumHazard")
        Number cumHazard) {
        this.time = time;
        this.cumHazard = cumHazard;
    }

    public Number requireTime() {
        if (this.time == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINECELL_TIME);
        }
        return this.time;
    }

    public Number getTime() {
        return time;
    }

    public BaselineCell setTime(
        @org.jpmml.model.annotations.Property("time")
        Number time) {
        this.time = time;
        return this;
    }

    public Number requireCumHazard() {
        if (this.cumHazard == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINECELL_CUMHAZARD);
        }
        return this.cumHazard;
    }

    public Number getCumHazard() {
        return cumHazard;
    }

    public BaselineCell setCumHazard(
        @org.jpmml.model.annotations.Property("cumHazard")
        Number cumHazard) {
        this.cumHazard = cumHazard;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public BaselineCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
