
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "regressionTables",
    "modelVerification"
})
@JsonRootName("RegressionModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "modelType",
    "targetField",
    "normalizationMethod",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "regressionTables",
    "modelVerification"
})
public class RegressionModel
    extends Model
    implements HasExtensions<RegressionModel> , HasTargetFieldReference<RegressionModel> , HasRegressionTables<RegressionModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "modelType")
    @JsonProperty("modelType")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_3_0))
    private RegressionModel.ModelType modelType;
    @XmlAttribute(name = "targetFieldName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetFieldName")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_3_0))
    private String targetField;
    @XmlAttribute(name = "normalizationMethod")
    @JsonProperty("normalizationMethod")
    private RegressionModel.NormalizationMethod normalizationMethod;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_0), removable = (true))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("RegressionTable")
    @CollectionElementType(RegressionTable.class)
    private List<RegressionTable> regressionTables;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371273L;

    public RegressionModel() {
    }

    @ValueConstructor
    public RegressionModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("regressionTables")
        List<RegressionTable> regressionTables) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.regressionTables = regressionTables;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public RegressionModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.REGRESSIONMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public RegressionModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public RegressionModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public RegressionModel.ModelType getModelType() {
        return modelType;
    }

    public RegressionModel setModelType(
        @org.jpmml.model.annotations.Property("modelType")
        RegressionModel.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @Override
    public String getTargetField() {
        return targetField;
    }

    @Override
    public RegressionModel setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public RegressionModel.NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return RegressionModel.NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    @Override
    public RegressionModel setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        RegressionModel.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public RegressionModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public RegressionModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public RegressionModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.REGRESSIONMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public RegressionModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public RegressionModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public RegressionModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public RegressionModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public RegressionModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public RegressionModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    @Override
    public boolean hasRegressionTables() {
        return ((this.regressionTables!= null)&&(!this.regressionTables.isEmpty()));
    }

    @Override
    public List<RegressionTable> requireRegressionTables() {
        if ((this.regressionTables == null)||this.regressionTables.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.REGRESSIONMODEL_REGRESSIONTABLES);
        }
        return this.regressionTables;
    }

    @Override
    public List<RegressionTable> getRegressionTables() {
        if (regressionTables == null) {
            regressionTables = new ArrayList<>();
        }
        return this.regressionTables;
    }

    @Override
    public RegressionModel addRegressionTables(RegressionTable... regressionTables) {
        getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public RegressionModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRegressionTables()) {
                status = PMMLObject.traverse(visitor, getRegressionTables());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ModelType
        implements StringValue<RegressionModel.ModelType>
    {

        @XmlEnumValue("linearRegression")
        @JsonProperty("linearRegression")
        LINEAR_REGRESSION("linearRegression"),
        @XmlEnumValue("stepwisePolynomialRegression")
        @JsonProperty("stepwisePolynomialRegression")
        STEPWISE_POLYNOMIAL_REGRESSION("stepwisePolynomialRegression"),
        @XmlEnumValue("logisticRegression")
        @JsonProperty("logisticRegression")
        LOGISTIC_REGRESSION("logisticRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static RegressionModel.ModelType fromValue(String v) {
            for (RegressionModel.ModelType c: RegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum NormalizationMethod
        implements StringValue<RegressionModel.NormalizationMethod>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("simplemax")
        @JsonProperty("simplemax")
        SIMPLEMAX("simplemax"),
        @XmlEnumValue("softmax")
        @JsonProperty("softmax")
        SOFTMAX("softmax"),
        @XmlEnumValue("logit")
        @JsonProperty("logit")
        LOGIT("logit"),
        @XmlEnumValue("probit")
        @JsonProperty("probit")
        PROBIT("probit"),
        @XmlEnumValue("cloglog")
        @JsonProperty("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("exp")
        @JsonProperty("exp")
        EXP("exp"),
        @XmlEnumValue("loglog")
        @JsonProperty("loglog")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        LOGLOG("loglog"),
        @XmlEnumValue("cauchit")
        @JsonProperty("cauchit")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        CAUCHIT("cauchit");
        private final String value;

        NormalizationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static RegressionModel.NormalizationMethod fromValue(String v) {
            for (RegressionModel.NormalizationMethod c: RegressionModel.NormalizationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
