
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "KalmanState", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "finalOmega",
    "finalStateVector",
    "hVector"
})
@JsonRootName("KalmanState")
@JsonPropertyOrder({
    "finalOmega",
    "finalStateVector",
    "hVector"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class KalmanState
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "FinalOmega", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalOmega")
    private FinalOmega finalOmega;
    @XmlElement(name = "FinalStateVector", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalStateVector")
    private FinalStateVector finalStateVector;
    @XmlElement(name = "HVector", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("HVector")
    private HVector hVector;
    private static final long serialVersionUID = 67371273L;

    public KalmanState() {
    }

    @ValueConstructor
    public KalmanState(
        @org.jpmml.model.annotations.Property("finalOmega")
        FinalOmega finalOmega,
        @org.jpmml.model.annotations.Property("finalStateVector")
        FinalStateVector finalStateVector) {
        this.finalOmega = finalOmega;
        this.finalStateVector = finalStateVector;
    }

    public FinalOmega requireFinalOmega() {
        if (this.finalOmega == null) {
            throw new MissingElementException(this, PMMLElements.KALMANSTATE_FINALOMEGA);
        }
        return this.finalOmega;
    }

    public FinalOmega getFinalOmega() {
        return finalOmega;
    }

    public KalmanState setFinalOmega(
        @org.jpmml.model.annotations.Property("finalOmega")
        FinalOmega finalOmega) {
        this.finalOmega = finalOmega;
        return this;
    }

    public FinalStateVector requireFinalStateVector() {
        if (this.finalStateVector == null) {
            throw new MissingElementException(this, PMMLElements.KALMANSTATE_FINALSTATEVECTOR);
        }
        return this.finalStateVector;
    }

    public FinalStateVector getFinalStateVector() {
        return finalStateVector;
    }

    public KalmanState setFinalStateVector(
        @org.jpmml.model.annotations.Property("finalStateVector")
        FinalStateVector finalStateVector) {
        this.finalStateVector = finalStateVector;
        return this;
    }

    public HVector getHVector() {
        return hVector;
    }

    public KalmanState setHVector(
        @org.jpmml.model.annotations.Property("hVector")
        HVector hVector) {
        this.hVector = hVector;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFinalOmega(), getFinalStateVector(), getHVector());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
