
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Level", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "")
@JsonRootName("Level")
@JsonPropertyOrder({
    "alpha",
    "quadraticSmoothedValue",
    "cubicSmoothedValue",
    "smoothedValue"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class Level
    extends PMMLObject
{

    @XmlAttribute(name = "alpha")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("alpha")
    private Number alpha;
    @XmlAttribute(name = "quadraticSmoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("quadraticSmoothedValue")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    private Number quadraticSmoothedValue;
    @XmlAttribute(name = "cubicSmoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("cubicSmoothedValue")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    private Number cubicSmoothedValue;
    @XmlAttribute(name = "smoothedValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("smoothedValue")
    private Number smoothedValue;
    private static final long serialVersionUID = 67371273L;

    public Number getAlpha() {
        return alpha;
    }

    public Level setAlpha(
        @Property("alpha")
        Number alpha) {
        this.alpha = alpha;
        return this;
    }

    public Number getQuadraticSmoothedValue() {
        return quadraticSmoothedValue;
    }

    public Level setQuadraticSmoothedValue(
        @Property("quadraticSmoothedValue")
        Number quadraticSmoothedValue) {
        this.quadraticSmoothedValue = quadraticSmoothedValue;
        return this;
    }

    public Number getCubicSmoothedValue() {
        return cubicSmoothedValue;
    }

    public Level setCubicSmoothedValue(
        @Property("cubicSmoothedValue")
        Number cubicSmoothedValue) {
        this.cubicSmoothedValue = cubicSmoothedValue;
        return this;
    }

    public Number getSmoothedValue() {
        return smoothedValue;
    }

    public Level setSmoothedValue(
        @Property("smoothedValue")
        Number smoothedValue) {
        this.smoothedValue = smoothedValue;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
