/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.rule_set;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.rule_set.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="RuleSelectionMethod", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="RuleSelectionMethod")
@JsonPropertyOrder(value={"criterion", "extensions"})
public class RuleSelectionMethod
extends PMMLObject
implements HasExtensions<RuleSelectionMethod> {
    @XmlAttribute(name="criterion", required=true)
    @JsonProperty(value="criterion")
    private Criterion criterion;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371273L;

    public RuleSelectionMethod() {
    }

    @ValueConstructor
    public RuleSelectionMethod(@Property(value="criterion") Criterion criterion) {
        this.criterion = criterion;
    }

    public Criterion requireCriterion() {
        if (this.criterion == null) {
            throw new MissingAttributeException(this, PMMLAttributes.RULESELECTIONMETHOD_CRITERION);
        }
        return this.criterion;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public RuleSelectionMethod setCriterion(@Property(value="criterion") Criterion criterion) {
        this.criterion = criterion;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RuleSelectionMethod addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Criterion implements StringValue<Criterion>
    {
        WEIGHTED_SUM("weightedSum"),
        WEIGHTED_MAX("weightedMax"),
        FIRST_HIT("firstHit");

        private final String value;

        private Criterion(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Criterion fromValue(String v) {
            for (Criterion c : Criterion.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

