
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Aggregate")
@JsonPropertyOrder({
    "field",
    "function",
    "groupField",
    "sqlWhere",
    "extensions"
})
public class Aggregate
    extends Expression
    implements HasExtensions<Aggregate> , HasFieldReference<Aggregate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "function", required = true)
    @JsonProperty("function")
    private Aggregate.Function function;
    @XmlAttribute(name = "groupField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("groupField")
    private String groupField;
    @XmlAttribute(name = "sqlWhere")
    @JsonProperty("sqlWhere")
    private String sqlWhere;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371274L;

    public Aggregate() {
    }

    @ValueConstructor
    public Aggregate(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("function")
        Aggregate.Function function) {
        this.field = field;
        this.function = function;
    }

    @AlternateValueConstructor
    public Aggregate(Field<?> field, Aggregate.Function function) {
        this(((field!= null)?field.requireName():null), function);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.AGGREGATE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public Aggregate setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public Aggregate.Function requireFunction() {
        if (this.function == null) {
            throw new MissingAttributeException(this, PMMLAttributes.AGGREGATE_FUNCTION);
        }
        return this.function;
    }

    public Aggregate.Function getFunction() {
        return function;
    }

    public Aggregate setFunction(
        @org.jpmml.model.annotations.Property("function")
        Aggregate.Function function) {
        this.function = function;
        return this;
    }

    public String getGroupField() {
        return groupField;
    }

    public Aggregate setGroupField(
        @org.jpmml.model.annotations.Property("groupField")
        String groupField) {
        this.groupField = groupField;
        return this;
    }

    public String getSqlWhere() {
        return sqlWhere;
    }

    public Aggregate setSqlWhere(
        @org.jpmml.model.annotations.Property("sqlWhere")
        String sqlWhere) {
        this.sqlWhere = sqlWhere;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Aggregate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Function
        implements StringValue<Aggregate.Function>
    {

        @XmlEnumValue("count")
        @JsonProperty("count")
        COUNT("count"),
        @XmlEnumValue("sum")
        @JsonProperty("sum")
        SUM("sum"),
        @XmlEnumValue("average")
        @JsonProperty("average")
        AVERAGE("average"),
        @XmlEnumValue("min")
        @JsonProperty("min")
        MIN("min"),
        @XmlEnumValue("max")
        @JsonProperty("max")
        MAX("max"),
        @XmlEnumValue("multiset")
        @JsonProperty("multiset")
        MULTISET("multiset");
        private final String value;

        Function(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Aggregate.Function fromValue(String v) {
            for (Aggregate.Function c: Aggregate.Function.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
