
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "value"
})
@JsonRootName("Constant")
@JsonPropertyOrder({
    "dataType",
    "missing",
    "value"
})
public class Constant
    extends Expression
    implements HasDataType<Constant>
{

    @XmlAttribute(name = "dataType")
    @JsonProperty("dataType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private DataType dataType;
    @XmlAttribute(name = "missing")
    @JsonProperty("missing")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private Boolean missing;
    @XmlValue
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @XmlValueExtension
    @JsonProperty("value")
    private Object value;
    private static final Boolean DEFAULT_MISSING = false;
    private static final long serialVersionUID = 67371274L;

    public Constant() {
    }

    @ValueConstructor
    public Constant(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public Constant setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public boolean isMissing() {
        if (missing == null) {
            return DEFAULT_MISSING;
        } else {
            return missing;
        }
    }

    public Constant setMissing(
        @org.jpmml.model.annotations.Property("missing")
        Boolean missing) {
        this.missing = missing;
        return this;
    }

    public Object getValue() {
        return value;
    }

    public Constant setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
