
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DefineFunction", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "parameterFields",
    "derivedFields",
    "expression"
})
@JsonRootName("DefineFunction")
@JsonPropertyOrder({
    "name",
    "opType",
    "dataType",
    "extensions",
    "parameterFields",
    "derivedFields",
    "expression"
})
public class DefineFunction
    extends org.dmg.pmml.PMMLObject
    implements HasExpression<DefineFunction> , HasExtensions<DefineFunction> , HasRequiredName<DefineFunction> , HasRequiredType<DefineFunction>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "optype", required = true)
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "dataType")
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "ParameterField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ParameterField")
    @CollectionElementType(ParameterField.class)
    private List<ParameterField> parameterFields;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DerivedField")
    @Added((org.dmg.pmml.Version.XPMML))
    @Since(("1.7.3"))
    @CollectionElementType(DerivedField.class)
    private List<DerivedField> derivedFields;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Lag.class)
    })
    @JsonProperty("Expression")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Constant", value = org.dmg.pmml.Constant.class),
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "NormContinuous", value = org.dmg.pmml.NormContinuous.class),
        @JsonSubTypes.Type(name = "NormDiscrete", value = org.dmg.pmml.NormDiscrete.class),
        @JsonSubTypes.Type(name = "Discretize", value = org.dmg.pmml.Discretize.class),
        @JsonSubTypes.Type(name = "MapValues", value = org.dmg.pmml.MapValues.class),
        @JsonSubTypes.Type(name = "TextIndex", value = org.dmg.pmml.TextIndex.class),
        @JsonSubTypes.Type(name = "Apply", value = org.dmg.pmml.Apply.class),
        @JsonSubTypes.Type(name = "Aggregate", value = org.dmg.pmml.Aggregate.class),
        @JsonSubTypes.Type(name = "Lag", value = org.dmg.pmml.Lag.class)
    })
    private Expression expression;
    private static final long serialVersionUID = 67371274L;

    public DefineFunction() {
    }

    @ValueConstructor
    public DefineFunction(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("opType")
        OpType opType,
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType,
        @org.jpmml.model.annotations.Property("parameterFields")
        List<ParameterField> parameterFields,
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
        this.parameterFields = parameterFields;
        this.expression = expression;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DEFINEFUNCTION_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public DefineFunction setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public OpType requireOpType() {
        if (this.opType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DEFINEFUNCTION_OPTYPE);
        }
        return this.opType;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public DefineFunction setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType requireDataType() {
        if (this.dataType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DEFINEFUNCTION_DATATYPE);
        }
        return this.dataType;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public DefineFunction setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public DefineFunction addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParameterFields() {
        return ((this.parameterFields!= null)&&(!this.parameterFields.isEmpty()));
    }

    public List<ParameterField> requireParameterFields() {
        if ((this.parameterFields == null)||this.parameterFields.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.DEFINEFUNCTION_PARAMETERFIELDS);
        }
        return this.parameterFields;
    }

    public List<ParameterField> getParameterFields() {
        if (parameterFields == null) {
            parameterFields = new ArrayList<>();
        }
        return this.parameterFields;
    }

    public DefineFunction addParameterFields(ParameterField... parameterFields) {
        getParameterFields().addAll(Arrays.asList(parameterFields));
        return this;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(!this.derivedFields.isEmpty()));
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<>();
        }
        return this.derivedFields;
    }

    public DefineFunction addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    @Override
    public Expression requireExpression() {
        if (this.expression == null) {
            throw new MissingElementException(this, PMMLElements.DEFINEFUNCTION_EXPRESSION);
        }
        return this.expression;
    }

    @Override
    public Expression getExpression() {
        return expression;
    }

    @Override
    public DefineFunction setExpression(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParameterFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParameterFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
