
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "linearNorms"
})
@JsonRootName("NormContinuous")
@JsonPropertyOrder({
    "mapMissingTo",
    "field",
    "outlierTreatment",
    "extensions",
    "linearNorms"
})
public class NormContinuous
    extends Expression
    implements HasExtensions<NormContinuous> , HasFieldReference<NormContinuous> , HasMapMissingTo<NormContinuous, Number> , HasOutlierTreatment<NormContinuous>
{

    @XmlAttribute(name = "mapMissingTo")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("mapMissingTo")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Number mapMissingTo;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "outliers")
    @JsonProperty("outliers")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private OutlierTreatmentMethod outlierTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "LinearNorm", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("LinearNorm")
    @CollectionElementType(LinearNorm.class)
    private List<LinearNorm> linearNorms;
    private static final long serialVersionUID = 67371274L;

    public NormContinuous() {
    }

    @ValueConstructor
    public NormContinuous(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("linearNorms")
        List<LinearNorm> linearNorms) {
        this.field = field;
        this.linearNorms = linearNorms;
    }

    @AlternateValueConstructor
    public NormContinuous(Field<?> field, List<LinearNorm> linearNorms) {
        this(((field!= null)?field.requireName():null), linearNorms);
    }

    @Override
    public Number getMapMissingTo() {
        return mapMissingTo;
    }

    @Override
    public NormContinuous setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Number mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NORMCONTINUOUS_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public NormContinuous setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public OutlierTreatmentMethod getOutlierTreatment() {
        if (outlierTreatment == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outlierTreatment;
        }
    }

    @Override
    public NormContinuous setOutlierTreatment(
        @org.jpmml.model.annotations.Property("outlierTreatment")
        OutlierTreatmentMethod outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public NormContinuous addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLinearNorms() {
        return ((this.linearNorms!= null)&&(!this.linearNorms.isEmpty()));
    }

    public List<LinearNorm> requireLinearNorms() {
        if ((this.linearNorms == null)||this.linearNorms.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.NORMCONTINUOUS_LINEARNORMS);
        }
        return this.linearNorms;
    }

    public List<LinearNorm> getLinearNorms() {
        if (linearNorms == null) {
            linearNorms = new ArrayList<>();
        }
        return this.linearNorms;
    }

    public NormContinuous addLinearNorms(LinearNorm... linearNorms) {
        getLinearNorms().addAll(Arrays.asList(linearNorms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLinearNorms()) {
                status = PMMLObject.traverse(visitor, getLinearNorms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
