
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Timestamp", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "content"
})
@JsonRootName("Timestamp")
@JsonPropertyOrder({
    "content"
})
public class Timestamp
    extends org.dmg.pmml.PMMLObject
    implements HasMixedContent<Timestamp>
{

    @XmlElementRef(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4", type = Extension.class, required = false)
    @XmlMixed
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    @CollectionElementType(Object.class)
    private List<Object> content;
    private static final long serialVersionUID = 67371274L;

    public Timestamp() {
    }

    @ValueConstructor
    public Timestamp(
        @Property("content")
        List<Object> content) {
        this.content = content;
    }

    @Override
    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    @Override
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return this.content;
    }

    @Override
    public Timestamp addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
