
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TestDistributions", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "baseline",
    "alternate"
})
@JsonRootName("TestDistributions")
@JsonPropertyOrder({
    "field",
    "testStatistic",
    "resetValue",
    "windowSize",
    "weightField",
    "normalizationScheme",
    "extensions",
    "baseline",
    "alternate"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class TestDistributions
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TestDistributions> , HasFieldReference<TestDistributions>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "testStatistic", required = true)
    @JsonProperty("testStatistic")
    private TestDistributions.TestStatistic testStatistic;
    @XmlAttribute(name = "resetValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("resetValue")
    private Number resetValue;
    @XmlAttribute(name = "windowSize")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("windowSize")
    private Integer windowSize;
    @XmlAttribute(name = "weightField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("weightField")
    private String weightField;
    @XmlAttribute(name = "normalizationScheme")
    @JsonProperty("normalizationScheme")
    private String normalizationScheme;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Baseline")
    private Baseline baseline;
    @XmlElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Alternate")
    private Alternate alternate;
    private static final Number DEFAULT_RESET_VALUE = new RealNumberAdapter().unmarshal("0.0");
    private static final Integer DEFAULT_WINDOW_SIZE = new IntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371274L;

    public TestDistributions() {
    }

    @ValueConstructor
    public TestDistributions(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("testStatistic")
        TestDistributions.TestStatistic testStatistic,
        @org.jpmml.model.annotations.Property("baseline")
        Baseline baseline) {
        this.field = field;
        this.testStatistic = testStatistic;
        this.baseline = baseline;
    }

    @AlternateValueConstructor
    public TestDistributions(Field<?> field, TestDistributions.TestStatistic testStatistic, Baseline baseline) {
        this(((field!= null)?field.requireName():null), testStatistic, baseline);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TESTDISTRIBUTIONS_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public TestDistributions setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public TestDistributions.TestStatistic requireTestStatistic() {
        if (this.testStatistic == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TESTDISTRIBUTIONS_TESTSTATISTIC);
        }
        return this.testStatistic;
    }

    public TestDistributions.TestStatistic getTestStatistic() {
        return testStatistic;
    }

    public TestDistributions setTestStatistic(
        @org.jpmml.model.annotations.Property("testStatistic")
        TestDistributions.TestStatistic testStatistic) {
        this.testStatistic = testStatistic;
        return this;
    }

    public Number getResetValue() {
        if (resetValue == null) {
            return DEFAULT_RESET_VALUE;
        } else {
            return resetValue;
        }
    }

    public TestDistributions setResetValue(
        @org.jpmml.model.annotations.Property("resetValue")
        Number resetValue) {
        this.resetValue = resetValue;
        return this;
    }

    public Integer getWindowSize() {
        if (windowSize == null) {
            return DEFAULT_WINDOW_SIZE;
        } else {
            return windowSize;
        }
    }

    public TestDistributions setWindowSize(
        @org.jpmml.model.annotations.Property("windowSize")
        Integer windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String getWeightField() {
        return weightField;
    }

    public TestDistributions setWeightField(
        @org.jpmml.model.annotations.Property("weightField")
        String weightField) {
        this.weightField = weightField;
        return this;
    }

    public String getNormalizationScheme() {
        return normalizationScheme;
    }

    public TestDistributions setNormalizationScheme(
        @org.jpmml.model.annotations.Property("normalizationScheme")
        String normalizationScheme) {
        this.normalizationScheme = normalizationScheme;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public TestDistributions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Baseline requireBaseline() {
        if (this.baseline == null) {
            throw new MissingElementException(this, PMMLElements.TESTDISTRIBUTIONS_BASELINE);
        }
        return this.baseline;
    }

    public Baseline getBaseline() {
        return baseline;
    }

    public TestDistributions setBaseline(
        @org.jpmml.model.annotations.Property("baseline")
        Baseline baseline) {
        this.baseline = baseline;
        return this;
    }

    public Alternate getAlternate() {
        return alternate;
    }

    public TestDistributions setAlternate(
        @org.jpmml.model.annotations.Property("alternate")
        Alternate alternate) {
        this.alternate = alternate;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaseline(), getAlternate());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum TestStatistic
        implements StringValue<TestDistributions.TestStatistic>
    {

        @XmlEnumValue("zValue")
        @JsonProperty("zValue")
        Z_VALUE("zValue"),
        @XmlEnumValue("chiSquareIndependence")
        @JsonProperty("chiSquareIndependence")
        CHI_SQUARE_INDEPENDENCE("chiSquareIndependence"),
        @XmlEnumValue("chiSquareDistribution")
        @JsonProperty("chiSquareDistribution")
        CHI_SQUARE_DISTRIBUTION("chiSquareDistribution"),
        @JsonProperty("CUSUM")
        CUSUM("CUSUM"),
        @XmlEnumValue("scalarProduct")
        @JsonProperty("scalarProduct")
        SCALAR_PRODUCT("scalarProduct");
        private final String value;

        TestStatistic(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TestDistributions.TestStatistic fromValue(String v) {
            for (TestDistributions.TestStatistic c: TestDistributions.TestStatistic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
