
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BayesianNetworkNodes", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "content"
})
@JsonRootName("BayesianNetworkNodes")
@JsonPropertyOrder({
    "extensions",
    "content"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class BayesianNetworkNodes
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BayesianNetworkNodes>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "DiscreteNode", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.DiscreteNode.class),
        @XmlElement(name = "ContinuousNode", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.ContinuousNode.class)
    })
    @JsonProperty("content")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "DiscreteNode", value = org.dmg.pmml.bayesian_network.DiscreteNode.class),
        @JsonSubTypes.Type(name = "ContinuousNode", value = org.dmg.pmml.bayesian_network.ContinuousNode.class)
    })
    @CollectionElementType(org.dmg.pmml.PMMLObject.class)
    private List<org.dmg.pmml.PMMLObject> content;
    private static final long serialVersionUID = 67371274L;

    public BayesianNetworkNodes() {
    }

    @ValueConstructor
    public BayesianNetworkNodes(
        @Property("content")
        List<org.dmg.pmml.PMMLObject> content) {
        this.content = content;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public BayesianNetworkNodes addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    public List<org.dmg.pmml.PMMLObject> requireContent() {
        if ((this.content == null)||this.content.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BAYESIANNETWORKNODES_CONTENT);
        }
        return this.content;
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return this.content;
    }

    public BayesianNetworkNodes addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
