
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "UniformDistributionForBN", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "lower",
    "upper"
})
@JsonRootName("UniformDistributionForBN")
@JsonPropertyOrder({
    "extensions",
    "lower",
    "upper"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class UniformDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<UniformDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Lower", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Lower")
    private Lower lower;
    @XmlElement(name = "Upper", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Upper")
    private Upper upper;
    private static final long serialVersionUID = 67371274L;

    public UniformDistribution() {
    }

    @ValueConstructor
    public UniformDistribution(
        @org.jpmml.model.annotations.Property("lower")
        Lower lower,
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public UniformDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Lower requireLower() {
        if (this.lower == null) {
            throw new MissingElementException(this, PMMLElements.UNIFORMDISTRIBUTION_LOWER);
        }
        return this.lower;
    }

    public Lower getLower() {
        return lower;
    }

    public UniformDistribution setLower(
        @org.jpmml.model.annotations.Property("lower")
        Lower lower) {
        this.lower = lower;
        return this;
    }

    public Upper requireUpper() {
        if (this.upper == null) {
            throw new MissingElementException(this, PMMLElements.UNIFORMDISTRIBUTION_UPPER);
        }
        return this.upper;
    }

    public Upper getUpper() {
        return upper;
    }

    public UniformDistribution setUpper(
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.upper = upper;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLower(), getUpper());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
