
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@JsonRootName("NearestNeighborModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfNeighbors",
    "continuousScoringMethod",
    "categoricalScoringMethod",
    "instanceIdVariable",
    "threshold",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
public class NearestNeighborModel
    extends Model
    implements HasExtensions<NearestNeighborModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfNeighbors")
    private Integer numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    @JsonProperty("continuousScoringMethod")
    private NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    @JsonProperty("categoricalScoringMethod")
    private NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("instanceIdVariable")
    private String instanceIdVariable;
    @XmlAttribute(name = "threshold")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("threshold")
    private Number threshold;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TrainingInstances")
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ComparisonMeasure")
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("KNNInputs")
    private KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private static final Number DEFAULT_THRESHOLD = new RealNumberAdapter().unmarshal("0.001");
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371274L;

    public NearestNeighborModel() {
    }

    @ValueConstructor
    public NearestNeighborModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        Integer numberOfNeighbors,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances,
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure,
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.miningFunction = miningFunction;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public NearestNeighborModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEARESTNEIGHBORMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public NearestNeighborModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public NearestNeighborModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer requireNumberOfNeighbors() {
        if (this.numberOfNeighbors == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEARESTNEIGHBORMODEL_NUMBEROFNEIGHBORS);
        }
        return this.numberOfNeighbors;
    }

    public Integer getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    public NearestNeighborModel setNumberOfNeighbors(
        @org.jpmml.model.annotations.Property("numberOfNeighbors")
        Integer numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    public NearestNeighborModel.ContinuousScoringMethod getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return NearestNeighborModel.ContinuousScoringMethod.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    public NearestNeighborModel setContinuousScoringMethod(
        @org.jpmml.model.annotations.Property("continuousScoringMethod")
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    public NearestNeighborModel.CategoricalScoringMethod getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    public NearestNeighborModel setCategoricalScoringMethod(
        @org.jpmml.model.annotations.Property("categoricalScoringMethod")
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    public String getInstanceIdVariable() {
        return instanceIdVariable;
    }

    public NearestNeighborModel setInstanceIdVariable(
        @org.jpmml.model.annotations.Property("instanceIdVariable")
        String instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    public Number getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public NearestNeighborModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public NearestNeighborModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public NearestNeighborModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public NearestNeighborModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public NearestNeighborModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public NearestNeighborModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public NearestNeighborModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public NearestNeighborModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public NearestNeighborModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public NearestNeighborModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TrainingInstances requireTrainingInstances() {
        if (this.trainingInstances == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_TRAININGINSTANCES);
        }
        return this.trainingInstances;
    }

    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    public NearestNeighborModel setTrainingInstances(
        @org.jpmml.model.annotations.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    public ComparisonMeasure requireComparisonMeasure() {
        if (this.comparisonMeasure == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_COMPARISONMEASURE);
        }
        return this.comparisonMeasure;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    public NearestNeighborModel setComparisonMeasure(
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public KNNInputs requireKNNInputs() {
        if (this.knnInputs == null) {
            throw new MissingElementException(this, PMMLElements.NEARESTNEIGHBORMODEL_KNNINPUTS);
        }
        return this.knnInputs;
    }

    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    public NearestNeighborModel setKNNInputs(
        @org.jpmml.model.annotations.Property("knnInputs")
        KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public NearestNeighborModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTrainingInstances(), getComparisonMeasure(), getKNNInputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CategoricalScoringMethod
        implements StringValue<NearestNeighborModel.CategoricalScoringMethod>
    {

        @XmlEnumValue("majorityVote")
        @JsonProperty("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        @JsonProperty("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote");
        private final String value;

        CategoricalScoringMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static NearestNeighborModel.CategoricalScoringMethod fromValue(String v) {
            for (NearestNeighborModel.CategoricalScoringMethod c: NearestNeighborModel.CategoricalScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ContinuousScoringMethod
        implements StringValue<NearestNeighborModel.ContinuousScoringMethod>
    {

        @XmlEnumValue("median")
        @JsonProperty("median")
        MEDIAN("median"),
        @XmlEnumValue("average")
        @JsonProperty("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        @JsonProperty("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage");
        private final String value;

        ContinuousScoringMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static NearestNeighborModel.ContinuousScoringMethod fromValue(String v) {
            for (NearestNeighborModel.ContinuousScoringMethod c: NearestNeighborModel.ContinuousScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
