
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Neuron", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "connections"
})
@JsonRootName("Neuron")
@JsonPropertyOrder({
    "id",
    "bias",
    "width",
    "altitude",
    "extensions",
    "connections"
})
public class Neuron
    extends NeuralEntity
    implements HasExtensions<Neuron>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "bias")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("bias")
    private Number bias;
    @XmlAttribute(name = "width")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("width")
    private Number width;
    @XmlAttribute(name = "altitude")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("altitude")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    private Number altitude;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Con", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Con")
    @CollectionElementType(Connection.class)
    private List<Connection> connections;
    private static final long serialVersionUID = 67371274L;

    public Neuron() {
    }

    @ValueConstructor
    public Neuron(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("connections")
        List<Connection> connections) {
        this.id = id;
        this.connections = connections;
    }

    @Override
    public String requireId() {
        if (this.id == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEURON_ID);
        }
        return this.id;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Neuron setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Number getBias() {
        return bias;
    }

    public Neuron setBias(
        @org.jpmml.model.annotations.Property("bias")
        Number bias) {
        this.bias = bias;
        return this;
    }

    public Number getWidth() {
        return width;
    }

    public Neuron setWidth(
        @org.jpmml.model.annotations.Property("width")
        Number width) {
        this.width = width;
        return this;
    }

    public Number getAltitude() {
        return altitude;
    }

    public Neuron setAltitude(
        @org.jpmml.model.annotations.Property("altitude")
        Number altitude) {
        this.altitude = altitude;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Neuron addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasConnections() {
        return ((this.connections!= null)&&(!this.connections.isEmpty()));
    }

    public List<Connection> requireConnections() {
        if ((this.connections == null)||this.connections.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.NEURON_CONNECTIONS);
        }
        return this.connections;
    }

    public List<Connection> getConnections() {
        if (connections == null) {
            connections = new ArrayList<>();
        }
        return this.connections;
    }

    public Neuron addConnections(Connection... connections) {
        getConnections().addAll(Arrays.asList(connections));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasConnections()) {
                status = PMMLObject.traverse(visitor, getConnections());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
