
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "numericPredictors",
    "categoricalPredictors",
    "predictorTerms"
})
@JsonRootName("RegressionTable")
@JsonPropertyOrder({
    "intercept",
    "targetCategory",
    "extensions",
    "numericPredictors",
    "categoricalPredictors",
    "predictorTerms"
})
public class RegressionTable
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RegressionTable>
{

    @XmlAttribute(name = "intercept", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("intercept")
    private Number intercept;
    @XmlAttribute(name = "targetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("targetCategory")
    private Object targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NumericPredictor")
    @CollectionElementType(NumericPredictor.class)
    private List<NumericPredictor> numericPredictors;
    @XmlElement(name = "CategoricalPredictor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("CategoricalPredictor")
    @CollectionElementType(CategoricalPredictor.class)
    private List<CategoricalPredictor> categoricalPredictors;
    @XmlElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PredictorTerm")
    @CollectionElementType(PredictorTerm.class)
    private List<PredictorTerm> predictorTerms;
    private static final long serialVersionUID = 67371274L;

    public RegressionTable() {
    }

    @ValueConstructor
    public RegressionTable(
        @org.jpmml.model.annotations.Property("intercept")
        Number intercept) {
        this.intercept = intercept;
    }

    public Number requireIntercept() {
        if (this.intercept == null) {
            throw new MissingAttributeException(this, PMMLAttributes.REGRESSIONTABLE_INTERCEPT);
        }
        return this.intercept;
    }

    public Number getIntercept() {
        return intercept;
    }

    public RegressionTable setIntercept(
        @org.jpmml.model.annotations.Property("intercept")
        Number intercept) {
        this.intercept = intercept;
        return this;
    }

    public Object requireTargetCategory() {
        if (this.targetCategory == null) {
            throw new MissingAttributeException(this, PMMLAttributes.REGRESSIONTABLE_TARGETCATEGORY);
        }
        return this.targetCategory;
    }

    public Object getTargetCategory() {
        return targetCategory;
    }

    public RegressionTable setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        Object targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public RegressionTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNumericPredictors() {
        return ((this.numericPredictors!= null)&&(!this.numericPredictors.isEmpty()));
    }

    public List<NumericPredictor> getNumericPredictors() {
        if (numericPredictors == null) {
            numericPredictors = new ArrayList<>();
        }
        return this.numericPredictors;
    }

    public RegressionTable addNumericPredictors(NumericPredictor... numericPredictors) {
        getNumericPredictors().addAll(Arrays.asList(numericPredictors));
        return this;
    }

    public boolean hasCategoricalPredictors() {
        return ((this.categoricalPredictors!= null)&&(!this.categoricalPredictors.isEmpty()));
    }

    public List<CategoricalPredictor> getCategoricalPredictors() {
        if (categoricalPredictors == null) {
            categoricalPredictors = new ArrayList<>();
        }
        return this.categoricalPredictors;
    }

    public RegressionTable addCategoricalPredictors(CategoricalPredictor... categoricalPredictors) {
        getCategoricalPredictors().addAll(Arrays.asList(categoricalPredictors));
        return this;
    }

    public boolean hasPredictorTerms() {
        return ((this.predictorTerms!= null)&&(!this.predictorTerms.isEmpty()));
    }

    public List<PredictorTerm> getPredictorTerms() {
        if (predictorTerms == null) {
            predictorTerms = new ArrayList<>();
        }
        return this.predictorTerms;
    }

    public RegressionTable addPredictorTerms(PredictorTerm... predictorTerms) {
        getPredictorTerms().addAll(Arrays.asList(predictorTerms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNumericPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNumericPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCategoricalPredictors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCategoricalPredictors());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredictorTerms()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredictorTerms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
