
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "ruleSet",
    "modelVerification"
})
@JsonRootName("RuleSetModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "ruleSet",
    "modelVerification"
})
public class RuleSetModel
    extends Model
    implements HasExtensions<RuleSetModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_0), removable = (true))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "RuleSet", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("RuleSet")
    private RuleSet ruleSet;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371274L;

    public RuleSetModel() {
    }

    @ValueConstructor
    public RuleSetModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("ruleSet")
        RuleSet ruleSet) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.ruleSet = ruleSet;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public RuleSetModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.RULESETMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public RuleSetModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public RuleSetModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public RuleSetModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public RuleSetModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public RuleSetModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.RULESETMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public RuleSetModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public RuleSetModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public RuleSetModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public RuleSetModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public RuleSetModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public RuleSetModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public RuleSet requireRuleSet() {
        if (this.ruleSet == null) {
            throw new MissingElementException(this, PMMLElements.RULESETMODEL_RULESET);
        }
        return this.ruleSet;
    }

    public RuleSet getRuleSet() {
        return ruleSet;
    }

    public RuleSetModel setRuleSet(
        @org.jpmml.model.annotations.Property("ruleSet")
        RuleSet ruleSet) {
        this.ruleSet = ruleSet;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public RuleSetModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getRuleSet(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
