
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasRequiredId;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SetPredicate", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@JsonRootName("SetPredicate")
@JsonPropertyOrder({
    "id",
    "field",
    "operator",
    "extensions",
    "array"
})
@Deprecated((org.dmg.pmml.Version.PMML_3_1))
public class SetPredicate
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SetPredicate> , HasFieldReference<SetPredicate> , HasRequiredId<SetPredicate> , HasValueSet<SetPredicate>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "operator")
    @JsonProperty("operator")
    private SetPredicate.Operator operator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    private static final long serialVersionUID = 67371274L;

    public SetPredicate() {
    }

    @ValueConstructor
    public SetPredicate(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.id = id;
        this.field = field;
        this.array = array;
    }

    @AlternateValueConstructor
    public SetPredicate(String id, Field<?> field, Array array) {
        this(id, ((field!= null)?field.requireName():null), array);
    }

    @Override
    public String requireId() {
        if (this.id == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SETPREDICATE_ID);
        }
        return this.id;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public SetPredicate setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SETPREDICATE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public SetPredicate setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public SetPredicate.Operator getOperator() {
        if (operator == null) {
            return SetPredicate.Operator.SUPERSET_OF;
        } else {
            return operator;
        }
    }

    public SetPredicate setOperator(
        @org.jpmml.model.annotations.Property("operator")
        SetPredicate.Operator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public SetPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.SETPREDICATE_ARRAY);
        }
        return this.array;
    }

    @Override
    public Array getArray() {
        return array;
    }

    @Override
    public SetPredicate setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Operator
        implements StringValue<SetPredicate.Operator>
    {

        @XmlEnumValue("supersetOf")
        @JsonProperty("supersetOf")
        SUPERSET_OF("supersetOf");
        private final String value;

        Operator(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SetPredicate.Operator fromValue(String v) {
            for (SetPredicate.Operator c: SetPredicate.Operator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
