
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "coefficients"
})
@JsonRootName("Coefficients")
@JsonPropertyOrder({
    "numberOfCoefficients",
    "absoluteValue",
    "extensions",
    "coefficients"
})
public class Coefficients
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Coefficient> , HasExtensions<Coefficients>
{

    @XmlAttribute(name = "numberOfCoefficients")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfCoefficients")
    @CollectionSize(("coefficients"))
    private Integer numberOfCoefficients;
    @XmlAttribute(name = "absoluteValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("absoluteValue")
    private Number absoluteValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Coefficient", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Coefficient")
    @CollectionElementType(Coefficient.class)
    private List<Coefficient> coefficients;
    private static final Number DEFAULT_ABSOLUTE_VALUE = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371274L;

    public Coefficients() {
    }

    @ValueConstructor
    public Coefficients(
        @org.jpmml.model.annotations.Property("coefficients")
        List<Coefficient> coefficients) {
        this.coefficients = coefficients;
    }

    public Integer getNumberOfCoefficients() {
        return numberOfCoefficients;
    }

    public Coefficients setNumberOfCoefficients(
        @org.jpmml.model.annotations.Property("numberOfCoefficients")
        Integer numberOfCoefficients) {
        this.numberOfCoefficients = numberOfCoefficients;
        return this;
    }

    public Number getAbsoluteValue() {
        if (absoluteValue == null) {
            return DEFAULT_ABSOLUTE_VALUE;
        } else {
            return absoluteValue;
        }
    }

    public Coefficients setAbsoluteValue(
        @org.jpmml.model.annotations.Property("absoluteValue")
        Number absoluteValue) {
        this.absoluteValue = absoluteValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Coefficients addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Coefficient> iterator() {
        return requireCoefficients().iterator();
    }

    public boolean hasCoefficients() {
        return ((this.coefficients!= null)&&(!this.coefficients.isEmpty()));
    }

    public List<Coefficient> requireCoefficients() {
        if ((this.coefficients == null)||this.coefficients.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.COEFFICIENTS_COEFFICIENTS);
        }
        return this.coefficients;
    }

    public List<Coefficient> getCoefficients() {
        if (coefficients == null) {
            coefficients = new ArrayList<>();
        }
        return this.coefficients;
    }

    public Coefficients addCoefficients(Coefficient... coefficients) {
        getCoefficients().addAll(Arrays.asList(coefficients));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCoefficients()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
