
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "FinalTheta", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "thetas"
})
@JsonRootName("FinalTheta")
@JsonPropertyOrder({
    "thetas"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class FinalTheta
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "Theta", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Theta")
    @CollectionElementType(Theta.class)
    private List<Theta> thetas;
    private static final long serialVersionUID = 67371274L;

    public FinalTheta() {
    }

    @ValueConstructor
    public FinalTheta(
        @Property("thetas")
        List<Theta> thetas) {
        this.thetas = thetas;
    }

    public boolean hasThetas() {
        return ((this.thetas!= null)&&(!this.thetas.isEmpty()));
    }

    public List<Theta> requireThetas() {
        if ((this.thetas == null)||this.thetas.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.FINALTHETA_THETAS);
        }
        return this.thetas;
    }

    public List<Theta> getThetas() {
        if (thetas == null) {
            thetas = new ArrayList<>();
        }
        return this.thetas;
    }

    public FinalTheta addThetas(Theta... thetas) {
        getThetas().addAll(Arrays.asList(thetas));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasThetas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getThetas());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
