
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "RegressorValues", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "timeSeries",
    "trendCoefficients",
    "transferFunctionValues"
})
@JsonRootName("RegressorValues")
@JsonPropertyOrder({
    "extensions",
    "timeSeries",
    "trendCoefficients",
    "transferFunctionValues"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class RegressorValues
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RegressorValues>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TimeSeries")
    private TimeSeries timeSeries;
    @XmlElement(name = "TrendCoefficients", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TrendCoefficients")
    private TrendCoefficients trendCoefficients;
    @XmlElement(name = "TransferFunctionValues", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TransferFunctionValues")
    private TransferFunctionValues transferFunctionValues;
    private static final long serialVersionUID = 67371274L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public RegressorValues addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TimeSeries getTimeSeries() {
        return timeSeries;
    }

    public RegressorValues setTimeSeries(
        @Property("timeSeries")
        TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
        return this;
    }

    public TrendCoefficients getTrendCoefficients() {
        return trendCoefficients;
    }

    public RegressorValues setTrendCoefficients(
        @Property("trendCoefficients")
        TrendCoefficients trendCoefficients) {
        this.trendCoefficients = trendCoefficients;
        return this;
    }

    public TransferFunctionValues getTransferFunctionValues() {
        return transferFunctionValues;
    }

    public RegressorValues setTransferFunctionValues(
        @Property("transferFunctionValues")
        TransferFunctionValues transferFunctionValues) {
        this.transferFunctionValues = transferFunctionValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeSeries(), getTrendCoefficients(), getTransferFunctionValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
