
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "StateSpaceModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "stateVector",
    "transitionMatrix",
    "measurementMatrix",
    "interceptVector",
    "predictedStateCovarianceMatrix",
    "selectedStateCovarianceMatrix",
    "observationVarianceMatrix",
    "psiVector",
    "dynamicRegressors"
})
@JsonRootName("StateSpaceModel")
@JsonPropertyOrder({
    "variance",
    "period",
    "intercept",
    "extensions",
    "stateVector",
    "transitionMatrix",
    "measurementMatrix",
    "interceptVector",
    "predictedStateCovarianceMatrix",
    "selectedStateCovarianceMatrix",
    "observationVarianceMatrix",
    "psiVector",
    "dynamicRegressors"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class StateSpaceModel
    extends Algorithm
    implements HasExtensions<StateSpaceModel> , HasDynamicRegressors<StateSpaceModel>
{

    @XmlAttribute(name = "variance")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("variance")
    private Number variance;
    @XmlAttribute(name = "period")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("period")
    private Object period;
    @XmlAttribute(name = "intercept")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("intercept")
    private Number intercept;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "StateVector", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("StateVector")
    private StateVector stateVector;
    @XmlElement(name = "TransitionMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TransitionMatrix")
    private TransitionMatrix transitionMatrix;
    @XmlElement(name = "MeasurementMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MeasurementMatrix")
    private MeasurementMatrix measurementMatrix;
    @XmlElement(name = "InterceptVector", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("InterceptVector")
    private InterceptVector interceptVector;
    @XmlElement(name = "PredictedStateCovarianceMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PredictedStateCovarianceMatrix")
    private PredictedStateCovarianceMatrix predictedStateCovarianceMatrix;
    @XmlElement(name = "SelectedStateCovarianceMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SelectedStateCovarianceMatrix")
    private SelectedStateCovarianceMatrix selectedStateCovarianceMatrix;
    @XmlElement(name = "ObservationVarianceMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ObservationVarianceMatrix")
    private ObservationVarianceMatrix observationVarianceMatrix;
    @XmlElement(name = "PsiVector", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PsiVector")
    private PsiVector psiVector;
    @XmlElement(name = "DynamicRegressor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DynamicRegressor")
    @CollectionElementType(DynamicRegressor.class)
    private List<DynamicRegressor> dynamicRegressors;
    private static final Object DEFAULT_PERIOD = new ObjectAdapter().unmarshal("none");
    private static final Number DEFAULT_INTERCEPT = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371274L;

    public Number getVariance() {
        return variance;
    }

    public StateSpaceModel setVariance(
        @Property("variance")
        Number variance) {
        this.variance = variance;
        return this;
    }

    public Object getPeriod() {
        if (period == null) {
            return DEFAULT_PERIOD;
        } else {
            return period;
        }
    }

    public StateSpaceModel setPeriod(
        @Property("period")
        Object period) {
        this.period = period;
        return this;
    }

    public Number getIntercept() {
        if (intercept == null) {
            return DEFAULT_INTERCEPT;
        } else {
            return intercept;
        }
    }

    public StateSpaceModel setIntercept(
        @Property("intercept")
        Number intercept) {
        this.intercept = intercept;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public StateSpaceModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public StateVector requireStateVector() {
        if (this.stateVector == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_STATEVECTOR);
        }
        return this.stateVector;
    }

    public StateVector getStateVector() {
        return stateVector;
    }

    public StateSpaceModel setStateVector(
        @Property("stateVector")
        StateVector stateVector) {
        this.stateVector = stateVector;
        return this;
    }

    public TransitionMatrix requireTransitionMatrix() {
        if (this.transitionMatrix == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_TRANSITIONMATRIX);
        }
        return this.transitionMatrix;
    }

    public TransitionMatrix getTransitionMatrix() {
        return transitionMatrix;
    }

    public StateSpaceModel setTransitionMatrix(
        @Property("transitionMatrix")
        TransitionMatrix transitionMatrix) {
        this.transitionMatrix = transitionMatrix;
        return this;
    }

    public MeasurementMatrix requireMeasurementMatrix() {
        if (this.measurementMatrix == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_MEASUREMENTMATRIX);
        }
        return this.measurementMatrix;
    }

    public MeasurementMatrix getMeasurementMatrix() {
        return measurementMatrix;
    }

    public StateSpaceModel setMeasurementMatrix(
        @Property("measurementMatrix")
        MeasurementMatrix measurementMatrix) {
        this.measurementMatrix = measurementMatrix;
        return this;
    }

    public InterceptVector getInterceptVector() {
        return interceptVector;
    }

    public StateSpaceModel setInterceptVector(
        @Property("interceptVector")
        InterceptVector interceptVector) {
        this.interceptVector = interceptVector;
        return this;
    }

    public PredictedStateCovarianceMatrix getPredictedStateCovarianceMatrix() {
        return predictedStateCovarianceMatrix;
    }

    public StateSpaceModel setPredictedStateCovarianceMatrix(
        @Property("predictedStateCovarianceMatrix")
        PredictedStateCovarianceMatrix predictedStateCovarianceMatrix) {
        this.predictedStateCovarianceMatrix = predictedStateCovarianceMatrix;
        return this;
    }

    public SelectedStateCovarianceMatrix getSelectedStateCovarianceMatrix() {
        return selectedStateCovarianceMatrix;
    }

    public StateSpaceModel setSelectedStateCovarianceMatrix(
        @Property("selectedStateCovarianceMatrix")
        SelectedStateCovarianceMatrix selectedStateCovarianceMatrix) {
        this.selectedStateCovarianceMatrix = selectedStateCovarianceMatrix;
        return this;
    }

    public ObservationVarianceMatrix getObservationVarianceMatrix() {
        return observationVarianceMatrix;
    }

    public StateSpaceModel setObservationVarianceMatrix(
        @Property("observationVarianceMatrix")
        ObservationVarianceMatrix observationVarianceMatrix) {
        this.observationVarianceMatrix = observationVarianceMatrix;
        return this;
    }

    public PsiVector getPsiVector() {
        return psiVector;
    }

    public StateSpaceModel setPsiVector(
        @Property("psiVector")
        PsiVector psiVector) {
        this.psiVector = psiVector;
        return this;
    }

    @Override
    public boolean hasDynamicRegressors() {
        return ((this.dynamicRegressors!= null)&&(!this.dynamicRegressors.isEmpty()));
    }

    @Override
    public List<DynamicRegressor> getDynamicRegressors() {
        if (dynamicRegressors == null) {
            dynamicRegressors = new ArrayList<>();
        }
        return this.dynamicRegressors;
    }

    @Override
    public StateSpaceModel addDynamicRegressors(DynamicRegressor... dynamicRegressors) {
        getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getStateVector(), getTransitionMatrix(), getMeasurementMatrix(), getInterceptVector(), getPredictedStateCovarianceMatrix(), getSelectedStateCovarianceMatrix(), getObservationVarianceMatrix(), getPsiVector());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, getDynamicRegressors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
