/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "predicates"})
@JsonRootName(value="CompoundPredicate")
@JsonPropertyOrder(value={"booleanOperator", "extensions", "predicates"})
public class CompoundPredicate
extends Predicate
implements HasExtensions<CompoundPredicate> {
    @XmlAttribute(name="booleanOperator", required=true)
    @JsonProperty(value="booleanOperator")
    private BooleanOperator booleanOperator;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_4", type=SimplePredicate.class), @XmlElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_4", type=CompoundPredicate.class), @XmlElement(name="SimpleSetPredicate", namespace="http://www.dmg.org/PMML-4_4", type=SimpleSetPredicate.class), @XmlElement(name="True", namespace="http://www.dmg.org/PMML-4_4", type=True.class), @XmlElement(name="False", namespace="http://www.dmg.org/PMML-4_4", type=False.class)})
    @JsonProperty(value="Predicate")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="SimplePredicate", value=SimplePredicate.class), @JsonSubTypes.Type(name="CompoundPredicate", value=CompoundPredicate.class), @JsonSubTypes.Type(name="SimpleSetPredicate", value=SimpleSetPredicate.class), @JsonSubTypes.Type(name="True", value=True.class), @JsonSubTypes.Type(name="False", value=False.class)})
    @CollectionElementType(value=Predicate.class)
    private List<Predicate> predicates;
    private static final long serialVersionUID = 67371274L;

    public CompoundPredicate() {
    }

    @ValueConstructor
    public CompoundPredicate(@Property(value="booleanOperator") BooleanOperator booleanOperator, @Property(value="predicates") List<Predicate> predicates) {
        this.booleanOperator = booleanOperator;
        this.predicates = predicates;
    }

    public BooleanOperator requireBooleanOperator() {
        if (this.booleanOperator == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPOUNDPREDICATE_BOOLEANOPERATOR);
        }
        return this.booleanOperator;
    }

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public CompoundPredicate setBooleanOperator(@Property(value="booleanOperator") BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public CompoundPredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredicates() {
        return this.predicates != null && !this.predicates.isEmpty();
    }

    public List<Predicate> requirePredicates() {
        if (this.predicates == null || this.predicates.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.COMPOUNDPREDICATE_PREDICATES);
        }
        return this.predicates;
    }

    public List<Predicate> getPredicates() {
        if (this.predicates == null) {
            this.predicates = new ArrayList<Predicate>();
        }
        return this.predicates;
    }

    public CompoundPredicate addPredicates(Predicate ... predicates) {
        this.getPredicates().addAll(Arrays.asList(predicates));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasPredicates()) {
                status = PMMLObject.traverse(visitor, this.getPredicates());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BooleanOperator implements StringValue<BooleanOperator>
    {
        OR("or"),
        AND("and"),
        XOR("xor"),
        SURROGATE("surrogate");

        private final String value;

        private BooleanOperator(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static BooleanOperator fromValue(String v) {
            for (BooleanOperator c : BooleanOperator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

