/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Counts", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Counts")
@JsonPropertyOrder(value={"totalFreq", "missingFreq", "invalidFreq", "cardinality", "extensions"})
public class Counts
extends PMMLObject
implements HasExtensions<Counts> {
    @XmlAttribute(name="totalFreq", required=true)
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="totalFreq")
    private Number totalFreq;
    @XmlAttribute(name="missingFreq")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="missingFreq")
    private Number missingFreq;
    @XmlAttribute(name="invalidFreq")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="invalidFreq")
    private Number invalidFreq;
    @XmlAttribute(name="cardinality")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="cardinality")
    @Added(value=Version.PMML_4_0)
    private Integer cardinality;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371274L;

    public Counts() {
    }

    @ValueConstructor
    public Counts(@Property(value="totalFreq") Number totalFreq) {
        this.totalFreq = totalFreq;
    }

    public Number requireTotalFreq() {
        if (this.totalFreq == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COUNTS_TOTALFREQ);
        }
        return this.totalFreq;
    }

    public Number getTotalFreq() {
        return this.totalFreq;
    }

    public Counts setTotalFreq(@Property(value="totalFreq") Number totalFreq) {
        this.totalFreq = totalFreq;
        return this;
    }

    public Number getMissingFreq() {
        return this.missingFreq;
    }

    public Counts setMissingFreq(@Property(value="missingFreq") Number missingFreq) {
        this.missingFreq = missingFreq;
        return this;
    }

    public Number getInvalidFreq() {
        return this.invalidFreq;
    }

    public Counts setInvalidFreq(@Property(value="invalidFreq") Number invalidFreq) {
        this.invalidFreq = invalidFreq;
        return this;
    }

    public Integer getCardinality() {
        return this.cardinality;
    }

    public Counts setCardinality(@Property(value="cardinality") Integer cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Counts addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

