/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decorable;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasContinuousDomain;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Value;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="DataField", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "intervals", "values"})
@JsonRootName(value="DataField")
@JsonPropertyOrder(value={"name", "displayName", "opType", "dataType", "taxonomy", "cyclic", "extensions", "intervals", "values"})
public class DataField
extends Field<DataField>
implements Decorable,
HasContinuousDomain<DataField>,
HasDiscreteDomain<DataField>,
HasExtensions<DataField> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="displayName")
    @JsonProperty(value="displayName")
    private String displayName;
    @XmlAttribute(name="optype", required=true)
    @JsonProperty(value="optype")
    private OpType opType;
    @XmlAttribute(name="dataType", required=true)
    @JsonProperty(value="dataType")
    @Required(value=Version.PMML_3_1)
    private DataType dataType;
    @XmlAttribute(name="taxonomy")
    @JsonProperty(value="taxonomy")
    private String taxonomy;
    @XmlAttribute(name="isCyclic")
    @JsonProperty(value="isCyclic")
    private Cyclic cyclic;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="Interval", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Interval")
    @CollectionElementType(value=Interval.class)
    private List<Interval> intervals;
    @XmlElement(name="Value", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Value")
    @CollectionElementType(value=Value.class)
    private List<Value> values;
    private static final long serialVersionUID = 67371274L;

    public DataField() {
    }

    @ValueConstructor
    public DataField(@Property(value="name") String name, @Property(value="opType") OpType opType, @Property(value="dataType") DataType dataType) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DATAFIELD_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataField setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public DataField setDisplayName(@Property(value="displayName") String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType requireOpType() {
        if (this.opType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DATAFIELD_OPTYPE);
        }
        return this.opType;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public DataField setOpType(@Property(value="opType") OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType requireDataType() {
        if (this.dataType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DATAFIELD_DATATYPE);
        }
        return this.dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataField setDataType(@Property(value="dataType") DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public DataField setTaxonomy(@Property(value="taxonomy") String taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public Cyclic getCyclic() {
        if (this.cyclic == null) {
            return Cyclic.ZERO;
        }
        return this.cyclic;
    }

    public DataField setCyclic(@Property(value="cyclic") Cyclic cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DataField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public boolean hasIntervals() {
        return this.intervals != null && !this.intervals.isEmpty();
    }

    @Override
    public List<Interval> getIntervals() {
        if (this.intervals == null) {
            this.intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    @Override
    public DataField addIntervals(Interval ... intervals) {
        this.getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    @Override
    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public List<Value> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
        }
        return this.values;
    }

    @Override
    public DataField addValues(Value ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasIntervals()) {
                status = PMMLObject.traverse(visitor, this.getIntervals());
            }
            if (status == VisitorAction.CONTINUE && this.hasValues()) {
                status = PMMLObject.traverse(visitor, this.getValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Cyclic implements StringValue<Cyclic>
    {
        ZERO("0"),
        ONE("1");

        private final String value;

        private Cyclic(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Cyclic fromValue(String v) {
            for (Cyclic c : Cyclic.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

