/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.HasDefaultValue;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.HasTable;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "fieldColumnPairs", "tableLocator", "inlineTable"})
@JsonRootName(value="MapValues")
@JsonPropertyOrder(value={"mapMissingTo", "defaultValue", "outputColumn", "dataType", "extensions", "fieldColumnPairs", "tableLocator", "inlineTable"})
public class MapValues
extends Expression
implements HasDataType<MapValues>,
HasDefaultValue<MapValues, Object>,
HasExtensions<MapValues>,
HasMapMissingTo<MapValues, Object>,
HasTable<MapValues> {
    @XmlAttribute(name="mapMissingTo")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="mapMissingTo")
    private Object mapMissingTo;
    @XmlAttribute(name="defaultValue")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="defaultValue")
    private Object defaultValue;
    @XmlAttribute(name="outputColumn", required=true)
    @JsonProperty(value="outputColumn")
    private String outputColumn;
    @XmlAttribute(name="dataType")
    @JsonProperty(value="dataType")
    @Added(value=Version.PMML_3_1)
    private DataType dataType;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="FieldColumnPair", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="FieldColumnPair")
    @Optional(value=Version.PMML_4_2)
    @CollectionElementType(value=FieldColumnPair.class)
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name="TableLocator", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TableLocator")
    private TableLocator tableLocator;
    @XmlElement(name="InlineTable", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="InlineTable")
    private InlineTable inlineTable;
    private static final long serialVersionUID = 67371274L;

    public MapValues() {
    }

    @ValueConstructor
    public MapValues(@Property(value="outputColumn") String outputColumn, @Property(value="inlineTable") InlineTable inlineTable) {
        this.outputColumn = outputColumn;
        this.inlineTable = inlineTable;
    }

    @Override
    public Object getMapMissingTo() {
        return this.mapMissingTo;
    }

    @Override
    public MapValues setMapMissingTo(@Property(value="mapMissingTo") Object mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public MapValues setDefaultValue(@Property(value="defaultValue") Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String requireOutputColumn() {
        if (this.outputColumn == null) {
            throw new MissingAttributeException(this, PMMLAttributes.MAPVALUES_OUTPUTCOLUMN);
        }
        return this.outputColumn;
    }

    public String getOutputColumn() {
        return this.outputColumn;
    }

    public MapValues setOutputColumn(@Property(value="outputColumn") String outputColumn) {
        this.outputColumn = outputColumn;
        return this;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public MapValues setDataType(@Property(value="dataType") DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MapValues addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return this.fieldColumnPairs != null && !this.fieldColumnPairs.isEmpty();
    }

    public List<FieldColumnPair> getFieldColumnPairs() {
        if (this.fieldColumnPairs == null) {
            this.fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    public MapValues addFieldColumnPairs(FieldColumnPair ... fieldColumnPairs) {
        this.getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public TableLocator getTableLocator() {
        return this.tableLocator;
    }

    @Override
    public MapValues setTableLocator(@Property(value="tableLocator") TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    public InlineTable requireInlineTable() {
        if (this.inlineTable == null) {
            throw new MissingElementException(this, PMMLElements.MAPVALUES_INLINETABLE);
        }
        return this.inlineTable;
    }

    @Override
    public InlineTable getInlineTable() {
        return this.inlineTable;
    }

    @Override
    public MapValues setInlineTable(@Property(value="inlineTable") InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasFieldColumnPairs()) {
                status = PMMLObject.traverse(visitor, this.getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getTableLocator(), (Visitable)this.getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

