/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "outputFields"})
@JsonRootName(value="Output")
@JsonPropertyOrder(value={"extensions", "outputFields"})
public class Output
extends PMMLObject
implements HasExtensions<Output> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="OutputField", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="OutputField")
    @CollectionElementType(value=OutputField.class)
    private List<OutputField> outputFields;
    private static final long serialVersionUID = 67371274L;

    public Output() {
    }

    @ValueConstructor
    public Output(@Property(value="outputFields") List<OutputField> outputFields) {
        this.outputFields = outputFields;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Output addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasOutputFields() {
        return this.outputFields != null && !this.outputFields.isEmpty();
    }

    public List<OutputField> requireOutputFields() {
        if (this.outputFields == null || this.outputFields.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.OUTPUT_OUTPUTFIELDS);
        }
        return this.outputFields;
    }

    public List<OutputField> getOutputFields() {
        if (this.outputFields == null) {
            this.outputFields = new ArrayList<OutputField>();
        }
        return this.outputFields;
    }

    public Output addOutputFields(OutputField ... outputFields) {
        this.getOutputFields().addAll(Arrays.asList(outputFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasOutputFields()) {
                status = PMMLObject.traverse(visitor, this.getOutputFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

