/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.naive_bayes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.naive_bayes.PMMLAttributes;
import org.dmg.pmml.naive_bayes.PMMLElements;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueStats;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="BayesInput", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "targetValueStats", "derivedField", "pairCounts"})
@JsonRootName(value="BayesInput")
@JsonPropertyOrder(value={"field", "extensions", "targetValueStats", "derivedField", "pairCounts"})
public class BayesInput
extends PMMLObject
implements HasExtensions<BayesInput>,
HasFieldReference<BayesInput> {
    @XmlAttribute(name="fieldName", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="fieldName")
    private String field;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="TargetValueStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TargetValueStats")
    @Added(value=Version.PMML_4_2)
    private TargetValueStats targetValueStats;
    @XmlElement(name="DerivedField", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="DerivedField")
    private DerivedField derivedField;
    @XmlElement(name="PairCounts", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="PairCounts")
    @CollectionElementType(value=PairCounts.class)
    private List<PairCounts> pairCounts;
    private static final long serialVersionUID = 67371274L;

    public BayesInput() {
    }

    @ValueConstructor
    public BayesInput(@Property(value="field") String field, @Property(value="targetValueStats") TargetValueStats targetValueStats, @Property(value="pairCounts") List<PairCounts> pairCounts) {
        this.field = field;
        this.targetValueStats = targetValueStats;
        this.pairCounts = pairCounts;
    }

    @AlternateValueConstructor
    public BayesInput(Field<?> field, TargetValueStats targetValueStats, List<PairCounts> pairCounts) {
        this(field != null ? field.requireName() : null, targetValueStats, pairCounts);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BAYESINPUT_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public BayesInput setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesInput addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TargetValueStats requireTargetValueStats() {
        if (this.targetValueStats == null) {
            throw new MissingElementException(this, PMMLElements.BAYESINPUT_TARGETVALUESTATS);
        }
        return this.targetValueStats;
    }

    public TargetValueStats getTargetValueStats() {
        return this.targetValueStats;
    }

    public BayesInput setTargetValueStats(@Property(value="targetValueStats") TargetValueStats targetValueStats) {
        this.targetValueStats = targetValueStats;
        return this;
    }

    public DerivedField getDerivedField() {
        return this.derivedField;
    }

    public BayesInput setDerivedField(@Property(value="derivedField") DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    public boolean hasPairCounts() {
        return this.pairCounts != null && !this.pairCounts.isEmpty();
    }

    public List<PairCounts> requirePairCounts() {
        if (this.pairCounts == null || this.pairCounts.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BAYESINPUT_PAIRCOUNTS);
        }
        return this.pairCounts;
    }

    public List<PairCounts> getPairCounts() {
        if (this.pairCounts == null) {
            this.pairCounts = new ArrayList<PairCounts>();
        }
        return this.pairCounts;
    }

    public BayesInput addPairCounts(PairCounts ... pairCounts) {
        this.getPairCounts().addAll(Arrays.asList(pairCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getTargetValueStats(), (Visitable)this.getDerivedField());
            }
            if (status == VisitorAction.CONTINUE && this.hasPairCounts()) {
                status = PMMLObject.traverse(visitor, this.getPairCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

