/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.nearest_neighbor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.nearest_neighbor.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="KNNInput")
@JsonPropertyOrder(value={"field", "fieldWeight", "compareFunction", "extensions"})
@Added(value=Version.PMML_4_1)
public class KNNInput
extends ComparisonField<KNNInput>
implements HasExtensions<KNNInput> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="fieldWeight")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="fieldWeight")
    private Number fieldWeight;
    @XmlAttribute(name="compareFunction")
    @JsonProperty(value="compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final Number DEFAULT_FIELD_WEIGHT = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371274L;

    public KNNInput() {
    }

    @ValueConstructor
    public KNNInput(@Property(value="field") String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public KNNInput(Field<?> field) {
        this(field != null ? field.requireName() : null);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.KNNINPUT_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public KNNInput setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    @Override
    public Number getFieldWeight() {
        if (this.fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        }
        return this.fieldWeight;
    }

    @Override
    public KNNInput setFieldWeight(@Property(value="fieldWeight") Number fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return this.compareFunction;
    }

    @Override
    public KNNInput setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KNNInput addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

