/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.sequence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.sequence.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Delimiter", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Delimiter")
@JsonPropertyOrder(value={"delimiter", "gap", "extensions"})
public class Delimiter
extends PMMLObject
implements HasExtensions<Delimiter> {
    @XmlAttribute(name="delimiter", required=true)
    @JsonProperty(value="delimiter")
    private TimeWindow delimiter;
    @XmlAttribute(name="gap", required=true)
    @JsonProperty(value="gap")
    private Gap gap;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371274L;

    public Delimiter() {
    }

    @ValueConstructor
    public Delimiter(@Property(value="delimiter") TimeWindow delimiter, @Property(value="gap") Gap gap) {
        this.delimiter = delimiter;
        this.gap = gap;
    }

    public TimeWindow requireDelimiter() {
        if (this.delimiter == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DELIMITER_DELIMITER);
        }
        return this.delimiter;
    }

    public TimeWindow getDelimiter() {
        return this.delimiter;
    }

    public Delimiter setDelimiter(@Property(value="delimiter") TimeWindow delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Gap requireGap() {
        if (this.gap == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DELIMITER_GAP);
        }
        return this.gap;
    }

    public Gap getGap() {
        return this.gap;
    }

    public Delimiter setGap(@Property(value="gap") Gap gap) {
        this.gap = gap;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Delimiter addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum TimeWindow implements StringValue<TimeWindow>
    {
        SAME_TIME_WINDOW("sameTimeWindow"),
        ACROSS_TIME_WINDOWS("acrossTimeWindows");

        private final String value;

        private TimeWindow(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static TimeWindow fromValue(String v) {
            for (TimeWindow c : TimeWindow.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Gap implements StringValue<Gap>
    {
        TRUE("true"),
        FALSE("false"),
        UNKNOWN("unknown");

        private final String value;

        private Gap(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Gap fromValue(String v) {
            for (Gap c : Gap.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

