/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class SliceUtil {
    private static final List<Integer> INDICES = new AbstractList<Integer>(){

        @Override
        public int size() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer get(int index) {
            if (index < 0) {
                throw new IllegalArgumentException();
            }
            return index;
        }
    };

    private SliceUtil() {
    }

    public static <E> List<E> slice(List<E> values, Integer start, Integer stop) {
        return SliceUtil.slice(values, start, stop, null);
    }

    public static <E> List<E> slice(List<E> values, Integer start, Integer stop, Integer step) {
        if (start == null) {
            start = 0;
        }
        if (stop == null) {
            stop = values.size();
        }
        if (step == null) {
            step = 1;
        }
        return SliceUtil.slice(values, (int)start, (int)stop, (int)step);
    }

    public static <E> List<E> slice(List<E> values, int start, int stop) {
        return SliceUtil.slice(values, start, stop, 1);
    }

    public static <E> List<E> slice(List<E> values, int start, int stop, int step) {
        if (start < 0) {
            start = values.size() + start;
        }
        if (stop < 0) {
            stop = values.size() + stop;
        }
        if (step <= 0) {
            throw new IllegalArgumentException();
        }
        start = Math.max(start, 0);
        stop = Math.min(stop, values.size());
        ArrayList<E> result = new ArrayList<E>();
        for (int i = start; i < stop; i += step) {
            E value = values.get(i);
            result.add(value);
        }
        return result;
    }

    public static List<Integer> indices(int start, int stop) {
        return SliceUtil.indices(start, stop, 1);
    }

    public static List<Integer> indices(int start, int stop, int step) {
        return SliceUtil.slice(INDICES, start, stop, step);
    }
}

