/*
 * Decompiled with CFR 0.152.
 */
package joblib;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.HasContent;
import org.jpmml.python.PythonObject;

public abstract class NDArrayWrapper
extends PythonObject
implements HasArray,
HasContent<NDArray> {
    private NDArray content = null;

    public NDArrayWrapper(String module, String name) {
        super(module, name);
    }

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public List<?> getArrayContent() {
        NDArray content = this.getContent();
        return content.getArrayContent();
    }

    @Override
    public int[] getArrayShape() {
        NDArray content = this.getContent();
        return content.getArrayShape();
    }

    @Override
    public Object getArrayType() {
        NDArray content = this.getContent();
        return content.getArrayType();
    }

    public String getFileName() {
        return this.getString("filename");
    }

    @Override
    public NDArray getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    @Override
    public void clearContent() {
        if (this.content != null) {
            this.content.clearContent();
        }
        this.content = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NDArray loadContent() {
        try (InputStream is = this.getInputStream();){
            NDArray nDArray = NDArrayUtil.parseNpy(is);
            return nDArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

