/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedInts;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import numpy.core.NDArrayUtil;
import org.dmg.pmml.DataType;

public class TypeDescriptor {
    private String descr = null;
    private ByteOrder byteOrder = null;
    private Kind kind = null;
    private int size = 0;

    public TypeDescriptor(String descr) {
        this.setDescr(descr);
        int i = 0;
        ByteOrder byteOrder = null;
        switch (descr.charAt(i)) {
            case '=': {
                byteOrder = ByteOrder.nativeOrder();
                ++i;
                break;
            }
            case '>': {
                byteOrder = ByteOrder.BIG_ENDIAN;
                ++i;
                break;
            }
            case '<': {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                ++i;
                break;
            }
            case '|': {
                ++i;
            }
        }
        this.setByteOrder(byteOrder);
        Kind kind = Kind.forChar(descr.charAt(i));
        this.setKind(kind);
        if (++i < descr.length()) {
            int size = Integer.parseInt(descr.substring(i));
            this.setSize(size);
        }
    }

    public DataType getDataType() {
        String descr = this.getDescr();
        Kind kind = this.getKind();
        int size = this.getSize();
        switch (kind) {
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case INTEGER: 
            case UNSIGNED_INTEGER: {
                return DataType.INTEGER;
            }
            case FLOAT: {
                switch (size) {
                    case 4: {
                        return DataType.FLOAT;
                    }
                    case 8: {
                        return DataType.DOUBLE;
                    }
                }
                throw new IllegalArgumentException(descr);
            }
            case OBJECT: {
                return DataType.STRING;
            }
            case STRING: 
            case UNICODE: {
                return DataType.STRING;
            }
        }
        throw new IllegalArgumentException(descr);
    }

    public Object read(InputStream is) throws IOException {
        String descr = this.getDescr();
        Kind kind = this.getKind();
        ByteOrder byteOrder = this.getByteOrder();
        int size = this.getSize();
        switch (kind) {
            case BOOLEAN: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readByte(is) == 1;
                    }
                }
                break;
            }
            case INTEGER: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readByte(is);
                    }
                    case 2: {
                        return NDArrayUtil.readShort(is, byteOrder);
                    }
                    case 4: {
                        return NDArrayUtil.readInt(is, byteOrder);
                    }
                    case 8: {
                        return NDArrayUtil.readLong(is, byteOrder);
                    }
                }
                break;
            }
            case UNSIGNED_INTEGER: {
                switch (size) {
                    case 1: {
                        return NDArrayUtil.readUnsignedByte(is);
                    }
                    case 2: {
                        return NDArrayUtil.readUnsignedShort(is, byteOrder);
                    }
                    case 4: {
                        return UnsignedInts.toLong((int)NDArrayUtil.readInt(is, byteOrder));
                    }
                    case 8: {
                        String string = Long.toUnsignedString(NDArrayUtil.readLong(is, byteOrder));
                        return Long.parseUnsignedLong(string);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (size) {
                    case 4: {
                        return Float.valueOf(NDArrayUtil.readFloat(is, byteOrder));
                    }
                    case 8: {
                        return NDArrayUtil.readDouble(is, byteOrder);
                    }
                }
                break;
            }
            case OBJECT: {
                return NDArrayUtil.readObject(is);
            }
            case STRING: {
                return NDArrayUtil.readString(is, size);
            }
            case UNICODE: {
                return NDArrayUtil.readUnicode(is, byteOrder, size);
            }
            case VOID: {
                byte[] buffer = new byte[size];
                ByteStreams.readFully((InputStream)is, (byte[])buffer);
                return buffer;
            }
        }
        throw new IllegalArgumentException(descr);
    }

    public boolean isObject() {
        Kind kind = this.getKind();
        switch (kind) {
            case OBJECT: {
                return true;
            }
        }
        return false;
    }

    public String getDescr() {
        return this.descr;
    }

    private void setDescr(String descr) {
        this.descr = descr;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public Kind getKind() {
        return this.kind;
    }

    private void setKind(Kind kind) {
        this.kind = kind;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public static enum Kind {
        BOOLEAN,
        INTEGER,
        UNSIGNED_INTEGER,
        FLOAT,
        COMPLEX_FLOAT,
        OBJECT,
        STRING,
        UNICODE,
        VOID;


        public static Kind forChar(char c) {
            switch (c) {
                case 'b': {
                    return BOOLEAN;
                }
                case 'i': {
                    return INTEGER;
                }
                case 'u': {
                    return UNSIGNED_INTEGER;
                }
                case 'f': {
                    return FLOAT;
                }
                case 'c': {
                    return COMPLEX_FLOAT;
                }
                case 'O': {
                    return OBJECT;
                }
                case 'S': 
                case 'a': {
                    return STRING;
                }
                case 'U': {
                    return UNICODE;
                }
                case 'V': {
                    return VOID;
                }
            }
            throw new IllegalArgumentException(String.valueOf(c));
        }
    }
}

