/*
 * Decompiled with CFR 0.152.
 */
package pycaret.preprocess;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.HasEstimator;
import sklearn.IdentityTransformer;
import sklearn.OutlierDetector;

public class RemoveOutliers
extends IdentityTransformer
implements HasEstimator<Estimator> {
    public RemoveOutliers(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Estimator estimator = this.getEstimator();
        CastFunction<OutlierDetector> castFunction = new CastFunction<OutlierDetector>(OutlierDetector.class){

            public String formatMessage(Object object) {
                return "The outlier detector object (" + ClassDictUtil.formatClass((Object)object) + ") is not supported";
            }
        };
        OutlierDetector outlierDetector = (OutlierDetector)castFunction.apply((Object)estimator);
        Schema schema = new Schema((PMMLEncoder)encoder, null, features);
        Model model = estimator.encode(schema);
        encoder.addTransformer(model);
        encoder.export(model, Arrays.asList(outlierDetector.getDecisionFunctionField(), outlierDetector.getOutlierField()));
        SimplePredicate predicate = new SimplePredicate(outlierDetector.getOutlierField(), SimplePredicate.Operator.EQUAL, (Object)false);
        encoder.setPredicate((Predicate)predicate);
        return super.encodeFeatures(features, encoder);
    }

    public Estimator getEstimator() {
        return (Estimator)this.get("_estimator", Estimator.class);
    }
}

