/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.ArrayList;
import java.util.List;
import net.razorvine.pickle.objects.ClassDictConstructor;
import numpy.DType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.CategoricalDtype;
import sklearn.Step;
import sklearn.StepUtil;

public abstract class Transformer
extends Step {
    public Transformer(String module, String name) {
        super(module, name);
    }

    public abstract List<Feature> encodeFeatures(List<Feature> var1, SkLearnEncoder var2);

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features_in_")) {
            return this.getInteger("n_features_in_");
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public List<Feature> encode(List<Feature> features, SkLearnEncoder encoder) {
        this.checkFeatures(features);
        features = this.updateFeatures(features, encoder);
        return this.encodeFeatures(features, encoder);
    }

    public void checkFeatures(List<? extends Feature> features) {
        StepUtil.checkNumberOfFeatures(this, features);
    }

    public List<Feature> updateFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        OpType opType;
        try {
            opType = this.getOpType();
            dataType = this.getDataType();
        }
        catch (UnsupportedOperationException uoe) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>(features.size());
        for (Feature feature : features) {
            if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                String name = wildcardFeature.getName();
                DataField dataField = encoder.getDataField(name);
                if (dataField == null) {
                    throw new IllegalArgumentException("Field " + name + " is undefined");
                }
                dataField = this.updateDataField(dataField, opType, dataType, encoder);
                feature = new WildcardFeature((PMMLEncoder)encoder, dataField);
            }
            result.add(feature);
        }
        return result;
    }

    public DataField updateDataField(DataField dataField, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        String name = dataField.requireName();
        if (encoder.isFrozen(name)) {
            return dataField;
        }
        switch (dataType) {
            case DOUBLE: {
                if (dataField.requireDataType() == DataType.DOUBLE) break;
                dataType = dataField.requireDataType();
            }
        }
        dataField.setOpType(opType).setDataType(dataType);
        return dataField;
    }

    public Object getOptionalDType(String name, boolean extended) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return this.getDType(name, extended);
    }

    public Object getDType(String name, boolean extended) {
        Object dtype = this.get(name);
        if (dtype instanceof String) {
            String string = (String)dtype;
            if (extended) {
                return string;
            }
        } else {
            if (dtype instanceof CategoricalDtype) {
                CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
                return categoricalDtype.getDType();
            }
            if (dtype instanceof ClassDictConstructor) {
                ClassDictConstructor dictConstructor = (ClassDictConstructor)dtype;
                return ClassDictConstructorUtil.construct((ClassDictConstructor)dictConstructor, DType.class);
            }
            if (dtype instanceof DType) {
                DType numpyDType = (DType)dtype;
                return numpyDType;
            }
        }
        return this.get(name, DType.class);
    }
}

